/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

public final class BucketFunctions {
    static final List<ValueFormatter> TIME_FORMATTERS = new ArrayList<ValueFormatter>();
    static final List<ValueFormatter> BINARY_FORMATTERS = new ArrayList<ValueFormatter>();
    static final List<ValueFormatter> DECIMAL_FORMATTERS = new ArrayList<ValueFormatter>();

    private static ValueFormatter fmt(long max, int width, String suffix, TimeUnit unit) {
        return new ValueFormatter(max, width, suffix, v -> unit.convert(v, TimeUnit.NANOSECONDS));
    }

    private static ValueFormatter bin(long max, int pow, int width, String suffix) {
        int shift = pow * 10;
        long maxBytes = shift == 0 ? max : max << shift;
        return new ValueFormatter(maxBytes, width, suffix, v -> v >> shift);
    }

    private static ValueFormatter dec(long max, int pow, int width, String suffix) {
        long factor = BucketFunctions.pow10(1L, pow);
        long maxBytes = max * factor;
        return new ValueFormatter(maxBytes, width, suffix, v -> v / factor);
    }

    private static long pow10(long a, int b) {
        long r = a;
        for (int i = 0; i < b; ++i) {
            r *= 10L;
        }
        return r;
    }

    private BucketFunctions() {
    }

    private static ValueFormatter getFormatter(List<ValueFormatter> fmts, long max) {
        for (ValueFormatter f : fmts) {
            if (max >= f.max) continue;
            return f;
        }
        return fmts.get(fmts.size() - 1);
    }

    private static LongFunction<String> biasZero(String ltZero, String gtMax, long max, ValueFormatter f) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        buckets.add(new Bucket(ltZero, -1L));
        buckets.add(f.newBucket(max / 8L));
        buckets.add(f.newBucket(max / 4L));
        buckets.add(f.newBucket(max / 2L));
        buckets.add(f.newBucket(max));
        return new ListBucketFunction(buckets, gtMax);
    }

    private static LongFunction<String> timeBiasZero(String ltZero, String gtMax, long max, TimeUnit unit) {
        long v = unit.toNanos(max);
        ValueFormatter f = BucketFunctions.getFormatter(TIME_FORMATTERS, v);
        return BucketFunctions.biasZero(ltZero, gtMax, v, f);
    }

    private static LongFunction<String> biasMax(String ltZero, String gtMax, long max, ValueFormatter f) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        buckets.add(new Bucket(ltZero, -1L));
        buckets.add(f.newBucket(max - max / 2L));
        buckets.add(f.newBucket(max - max / 4L));
        buckets.add(f.newBucket(max - max / 8L));
        buckets.add(f.newBucket(max));
        return new ListBucketFunction(buckets, gtMax);
    }

    private static LongFunction<String> timeBiasMax(String ltZero, String gtMax, long max, TimeUnit unit) {
        long v = unit.toNanos(max);
        ValueFormatter f = BucketFunctions.getFormatter(TIME_FORMATTERS, v);
        return BucketFunctions.biasMax(ltZero, gtMax, v, f);
    }

    public static LongFunction<String> age(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasZero("future", "old", max, unit);
    }

    public static LongFunction<String> latency(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasZero("negative_latency", "slow", max, unit);
    }

    public static LongFunction<String> ageBiasOld(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasMax("future", "old", max, unit);
    }

    public static LongFunction<String> latencyBiasSlow(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasMax("negative_latency", "slow", max, unit);
    }

    public static LongFunction<String> bytes(long max) {
        ValueFormatter f = BucketFunctions.getFormatter(BINARY_FORMATTERS, max);
        return BucketFunctions.biasZero("negative", "large", max, f);
    }

    public static LongFunction<String> decimal(long max) {
        ValueFormatter f = BucketFunctions.getFormatter(DECIMAL_FORMATTERS, max);
        return BucketFunctions.biasZero("negative", "large", max, f);
    }

    static {
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.NANOSECONDS.toNanos(10L), 1, "ns", TimeUnit.NANOSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.NANOSECONDS.toNanos(100L), 2, "ns", TimeUnit.NANOSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(1L), 3, "ns", TimeUnit.NANOSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(8L), 4, "ns", TimeUnit.NANOSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(10L), 1, "us", TimeUnit.MICROSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(100L), 2, "us", TimeUnit.MICROSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(1L), 3, "us", TimeUnit.MICROSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(8L), 4, "us", TimeUnit.MICROSECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(10L), 1, "ms", TimeUnit.MILLISECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(100L), 2, "ms", TimeUnit.MILLISECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(1L), 3, "ms", TimeUnit.MILLISECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(8L), 4, "ms", TimeUnit.MILLISECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(10L), 1, "s", TimeUnit.SECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(100L), 2, "s", TimeUnit.SECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MINUTES.toNanos(8L), 3, "s", TimeUnit.SECONDS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MINUTES.toNanos(10L), 1, "min", TimeUnit.MINUTES));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MINUTES.toNanos(100L), 2, "min", TimeUnit.MINUTES));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.HOURS.toNanos(8L), 3, "min", TimeUnit.MINUTES));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.HOURS.toNanos(10L), 1, "h", TimeUnit.HOURS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.HOURS.toNanos(100L), 2, "h", TimeUnit.HOURS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(8L), 1, "h", TimeUnit.HOURS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(10L), 1, "d", TimeUnit.DAYS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(100L), 2, "d", TimeUnit.DAYS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(1000L), 3, "d", TimeUnit.DAYS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(10000L), 4, "d", TimeUnit.DAYS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(100000L), 5, "d", TimeUnit.DAYS));
        TIME_FORMATTERS.add(BucketFunctions.fmt(Long.MAX_VALUE, 6, "d", TimeUnit.DAYS));
        String[] binaryUnits = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB"};
        for (int i = 0; i < binaryUnits.length; ++i) {
            BINARY_FORMATTERS.add(BucketFunctions.bin(10L, i, 1, "_" + binaryUnits[i]));
            BINARY_FORMATTERS.add(BucketFunctions.bin(100L, i, 2, "_" + binaryUnits[i]));
            BINARY_FORMATTERS.add(BucketFunctions.bin(1000L, i, 3, "_" + binaryUnits[i]));
            BINARY_FORMATTERS.add(BucketFunctions.bin(10000L, i, 4, "_" + binaryUnits[i]));
        }
        BINARY_FORMATTERS.add(new ValueFormatter(Long.MAX_VALUE, 4, "_PiB", v -> v >> 50));
        String[] decimalUnits = new String[]{"", "_k", "_M", "_G", "_T", "_P"};
        for (int i = 0; i < decimalUnits.length; ++i) {
            int pow = i * 3;
            DECIMAL_FORMATTERS.add(BucketFunctions.dec(10L, pow, 1, decimalUnits[i]));
            DECIMAL_FORMATTERS.add(BucketFunctions.dec(100L, pow, 2, decimalUnits[i]));
            DECIMAL_FORMATTERS.add(BucketFunctions.dec(1000L, pow, 3, decimalUnits[i]));
        }
        DECIMAL_FORMATTERS.add(new ValueFormatter(Long.MAX_VALUE, 1, "_E", v -> v / BucketFunctions.pow10(1L, 18)));
    }

    private static class Bucket {
        private final String name;
        private final long upperBoundary;

        Bucket(String name, long upperBoundary) {
            this.name = name;
            this.upperBoundary = upperBoundary;
        }

        public String toString() {
            return String.format("Bucket(%s,%d)", this.name, this.upperBoundary);
        }
    }

    private static class ListBucketFunction
    implements LongFunction<String> {
        private final List<Bucket> buckets;
        private final String fallback;

        ListBucketFunction(List<Bucket> buckets, String fallback) {
            this.buckets = buckets;
            this.fallback = fallback;
        }

        @Override
        public String apply(long amount) {
            for (Bucket b : this.buckets) {
                if (amount > b.upperBoundary) continue;
                return b.name;
            }
            return this.fallback;
        }
    }

    static class ValueFormatter {
        private final long max;
        private final String fmt;
        private final LongUnaryOperator cnv;

        ValueFormatter(long max, int width, String suffix, LongUnaryOperator cnv) {
            this.max = max;
            this.fmt = "%0" + width + "d" + suffix;
            this.cnv = cnv;
        }

        long max() {
            return this.max;
        }

        long convert(long v) {
            return this.cnv.applyAsLong(v);
        }

        String apply(long v) {
            return String.format(this.fmt, this.cnv.applyAsLong(v));
        }

        Bucket newBucket(long v) {
            return new Bucket(this.apply(v), v);
        }
    }
}

