/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<T> it;
    private final Predicate<T> p;
    private T item;

    FilteredIterator(Iterator<T> it, Predicate<T> p) {
        this.it = it;
        this.p = p;
        this.findNext();
    }

    private void findNext() {
        while (this.it.hasNext()) {
            this.item = this.it.next();
            if (!this.p.apply(this.item)) continue;
            return;
        }
        this.item = null;
    }

    @Override
    public boolean hasNext() {
        return this.item != null;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.item == null) {
            throw new NoSuchElementException("next() called after reaching end of iterator");
        }
        T tmp = this.item;
        this.findNext();
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

