/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Config;
import com.netflix.spectator.api.ConfigMap;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SystemConfigMap;
import com.netflix.spectator.api.Throwables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spectator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Spectator.class);
    private static final ConfigMap CONFIG = Spectator.newConfigMapUsingServiceLoader();
    private static final ExtendedRegistry REGISTRY = new ExtendedRegistry(Spectator.newInstance(Config.registryClass()));

    static ConfigMap newConfigMapUsingServiceLoader() {
        ServiceLoader<ConfigMap> loader = ServiceLoader.load(ConfigMap.class);
        Iterator<ConfigMap> cfgIterator = loader.iterator();
        if (cfgIterator.hasNext()) {
            ConfigMap cfg = cfgIterator.next();
            LOGGER.info("using config impl found in classpath: {}", (Object)cfg.getClass().getName());
            return cfg;
        }
        LOGGER.warn("no config impl found in classpath, using default");
        return new SystemConfigMap();
    }

    static Registry newInstanceUsingServiceLoader() {
        ServiceLoader<Registry> loader = ServiceLoader.load(Registry.class);
        Iterator<Registry> registryIterator = loader.iterator();
        if (registryIterator.hasNext()) {
            Registry r;
            StringBuilder desc = new StringBuilder();
            ArrayList<Registry> rs = new ArrayList<Registry>();
            while (registryIterator.hasNext()) {
                r = registryIterator.next();
                desc.append(' ').append(r.getClass().getName());
                rs.add(r);
            }
            r = rs.size() == 1 ? (Registry)rs.get(0) : new CompositeRegistry(Clock.SYSTEM, rs.toArray(new Registry[rs.size()]));
            LOGGER.info("using registries found in classpath: {}", (Object)desc.toString());
            return r;
        }
        LOGGER.warn("no registry impl found in classpath, using default");
        return new DefaultRegistry();
    }

    static Registry newInstanceUsingClassName(String name) {
        try {
            Class<?> c = Class.forName(name);
            return (Registry)c.newInstance();
        }
        catch (Exception e) {
            String msg = "failed to instantiate registry class '" + name + "', falling back to default implementation";
            Throwables.propagate(new RuntimeException(msg, e));
            return new DefaultRegistry();
        }
    }

    static Registry newInstance(String name) {
        return "service-loader".equals(name) ? Spectator.newInstanceUsingServiceLoader() : Spectator.newInstanceUsingClassName(name);
    }

    public static ConfigMap config() {
        return CONFIG;
    }

    public static ExtendedRegistry registry() {
        return REGISTRY;
    }

    private Spectator() {
    }
}

