/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.apache;

import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.BaseMetricPoller;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import com.netflix.servo.util.UnmodifiableList;
import com.netflix.servo.util.UnmodifiableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApacheStatusPoller
extends BaseMetricPoller {
    private final StatusFetcher fetcher;
    private static final List<Metric> EMPTY_LIST = Collections.emptyList();

    public ApacheStatusPoller(StatusFetcher fetcher) {
        this.fetcher = fetcher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Metric> pollImpl(long timestamp) {
        try (InputStream statusStream = this.fetcher.fetchStatus();){
            List<Metric> list = StatusPageParser.parse(statusStream, timestamp);
            return list;
        }
        catch (IOException e) {
            this.logger.error("Could not fetch status page", (Throwable)e);
            return EMPTY_LIST;
        }
    }

    public List<Metric> pollImpl(boolean reset) {
        return this.pollImpl(System.currentTimeMillis());
    }

    private static final class StatusPageParser {
        private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_\\-\\.]");
        private static final Pattern STAT_LINE = Pattern.compile("^([^:]+): ([.\\d]+)$");
        private static final Pattern SCOREBOARD_LINE = Pattern.compile("^Scoreboard: (\\S+)$");
        private static final char[] SCOREBOARD_CHARS = new char[]{'_', 'S', 'R', 'W', 'K', 'D', 'C', 'L', 'G', 'I', '.', '*'};
        private static final Tag CLASS_TAG = Tags.newTag((String)"class", (String)"ApacheStatusPoller");
        private static final Set<String> WHITELISTED_METRICS = UnmodifiableSet.of((Object[])new String[]{"Total_Accesses", "Total_kBytes", "Uptime", "BusyWorkers", "IdleWorkers", "ConnsTotal", "ConnsAsyncWriting", "ConnsAsyncKeepAlive", "ConnsAsyncClosing"});
        private static final int ASCII_CHARS = 128;
        private static final String SCOREBOARD = "Scoreboard";

        private StatusPageParser() {
        }

        private static String getScoreboardName(char c) {
            switch (c) {
                case '_': {
                    return "WaitingForConnection";
                }
                case 'S': {
                    return "StartingUp";
                }
                case 'R': {
                    return "ReadingRequest";
                }
                case 'W': {
                    return "SendingReply";
                }
                case 'K': {
                    return "Keepalive";
                }
                case 'D': {
                    return "DnsLookup";
                }
                case 'C': {
                    return "ClosingConnection";
                }
                case 'L': {
                    return "Logging";
                }
                case 'G': {
                    return "GracefullyFinishing";
                }
                case 'I': {
                    return "IdleCleanupOfWorker";
                }
                case '.': {
                    return "OpenSlotWithNoCurrentProcess";
                }
            }
            return "UnknownState";
        }

        static List<Metric> parseStatLine(String line, long timestamp) {
            Matcher m = STAT_LINE.matcher(line);
            if (!m.matches()) {
                return EMPTY_LIST;
            }
            String name = INVALID_CHARS.matcher(m.group(1)).replaceAll("_");
            if (!WHITELISTED_METRICS.contains(name)) {
                return EMPTY_LIST;
            }
            double value = Double.parseDouble(m.group(2));
            DataSourceType metricType = name.startsWith("Total") || name.startsWith("Uptime") ? DataSourceType.COUNTER : DataSourceType.GAUGE;
            MonitorConfig monitorConfig = MonitorConfig.builder((String)name).withTag((Tag)metricType).withTag(CLASS_TAG).build();
            Metric metric = new Metric(monitorConfig, timestamp, (Object)value);
            return UnmodifiableList.of((Object[])new Metric[]{metric});
        }

        static List<Metric> parseScoreboardLine(String line, long timestamp) {
            Matcher m = SCOREBOARD_LINE.matcher(line);
            if (!m.matches()) {
                return EMPTY_LIST;
            }
            char[] scoreboard = m.group(1).toCharArray();
            double[] tally = new double[128];
            for (char item : SCOREBOARD_CHARS) {
                tally[item] = 0.0;
            }
            for (char item : scoreboard) {
                int idx;
                int n = idx = item % 128;
                tally[n] = tally[n] + 1.0;
            }
            ArrayList<Metric> scoreboardMetrics = new ArrayList<Metric>();
            for (char item : SCOREBOARD_CHARS) {
                if (item == '.') continue;
                double value = tally[item];
                String state = StatusPageParser.getScoreboardName(item);
                MonitorConfig monitorConfig = MonitorConfig.builder((String)SCOREBOARD).withTag((Tag)DataSourceType.GAUGE).withTag(CLASS_TAG).withTag("state", state).build();
                Metric metric = new Metric(monitorConfig, timestamp, (Object)value);
                scoreboardMetrics.add(metric);
            }
            return Collections.unmodifiableList(scoreboardMetrics);
        }

        static List<Metric> parse(InputStream input, long timestamp) throws IOException {
            ArrayList<Metric> metrics = new ArrayList<Metric>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith(SCOREBOARD)) {
                        metrics.addAll(StatusPageParser.parseScoreboardLine(line, timestamp));
                    } else {
                        metrics.addAll(StatusPageParser.parseStatLine(line, timestamp));
                    }
                    line = reader.readLine();
                }
            }
            return Collections.unmodifiableList(metrics);
        }
    }

    public static class URLStatusFetcher
    implements StatusFetcher {
        private final URL url;

        public URLStatusFetcher(String url) throws MalformedURLException {
            this(new URL(url));
        }

        public URLStatusFetcher(URL url) {
            this.url = url;
        }

        @Override
        public InputStream fetchStatus() throws IOException {
            URLConnection con = this.url.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(2000);
            return con.getInputStream();
        }
    }

    public static interface StatusFetcher {
        public InputStream fetchStatus() throws IOException;
    }
}

