/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.demo;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.examples.demo.CreditCardCommand;
import com.netflix.hystrix.examples.demo.GetOrderCommand;
import com.netflix.hystrix.examples.demo.GetPaymentInformationCommand;
import com.netflix.hystrix.examples.demo.GetUserAccountCommand;
import com.netflix.hystrix.examples.demo.Order;
import com.netflix.hystrix.examples.demo.PaymentInformation;
import com.netflix.hystrix.examples.demo.UserAccount;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.math.BigDecimal;
import java.net.HttpCookie;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HystrixCommandDemo {
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 5, 5L, TimeUnit.DAYS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());

    public static void main(String[] args) {
        new HystrixCommandDemo().startDemo();
    }

    public HystrixCommandDemo() {
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.coreSize", (Object)8);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.CreditCardCommand.execution.isolation.thread.timeoutInMilliseconds", (Object)3000);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.GetUserAccountCommand.execution.isolation.thread.timeoutInMilliseconds", (Object)50);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.numBuckets", (Object)60);
    }

    public void startDemo() {
        this.startMetricsMonitor();
        while (true) {
            this.runSimulatedRequestOnThread();
        }
    }

    public void runSimulatedRequestOnThread() {
        this.pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HystrixRequestContext context = HystrixRequestContext.initializeContext();
                try {
                    HystrixCommandDemo.this.executeSimulatedUserRequestForOrderConfirmationAndCreditCardPayment();
                    System.out.println("Request => " + HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    context.shutdown();
                }
            }
        });
    }

    public void executeSimulatedUserRequestForOrderConfirmationAndCreditCardPayment() throws InterruptedException, ExecutionException {
        UserAccount user = (UserAccount)new GetUserAccountCommand(new HttpCookie("mockKey", "mockValueFromHttpRequest")).execute();
        Future paymentInformation = new GetPaymentInformationCommand(user).queue();
        int orderIdFromRequestArgument = 13579;
        Order previouslySavedOrder = (Order)new GetOrderCommand(orderIdFromRequestArgument).execute();
        CreditCardCommand credit = new CreditCardCommand(previouslySavedOrder, (PaymentInformation)paymentInformation.get(), new BigDecimal(123.45));
        credit.execute();
    }

    public void startMetricsMonitor() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    HystrixCommandMetrics creditCardMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)CreditCardCommand.class.getSimpleName()));
                    HystrixCommandMetrics orderMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)GetOrderCommand.class.getSimpleName()));
                    HystrixCommandMetrics userAccountMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)GetUserAccountCommand.class.getSimpleName()));
                    HystrixCommandMetrics paymentInformationMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)GetPaymentInformationCommand.class.getSimpleName()));
                    StringBuilder out = new StringBuilder();
                    out.append("\n");
                    out.append("#####################################################################################").append("\n");
                    out.append("# CreditCardCommand: " + this.getStatsStringFromMetrics(creditCardMetrics)).append("\n");
                    out.append("# GetOrderCommand: " + this.getStatsStringFromMetrics(orderMetrics)).append("\n");
                    out.append("# GetUserAccountCommand: " + this.getStatsStringFromMetrics(userAccountMetrics)).append("\n");
                    out.append("# GetPaymentInformationCommand: " + this.getStatsStringFromMetrics(paymentInformationMetrics)).append("\n");
                    out.append("#####################################################################################").append("\n");
                    System.out.println(out.toString());
                }
            }

            private String getStatsStringFromMetrics(HystrixCommandMetrics metrics) {
                StringBuilder m = new StringBuilder();
                if (metrics != null) {
                    HystrixCommandMetrics.HealthCounts health = metrics.getHealthCounts();
                    m.append("Requests: ").append(health.getTotalRequests()).append(" ");
                    m.append("Errors: ").append(health.getErrorCount()).append(" (").append(health.getErrorPercentage()).append("%)   ");
                    m.append("Mean: ").append(metrics.getExecutionTimePercentile(50.0)).append(" ");
                    m.append("75th: ").append(metrics.getExecutionTimePercentile(75.0)).append(" ");
                    m.append("90th: ").append(metrics.getExecutionTimePercentile(90.0)).append(" ");
                    m.append("99th: ").append(metrics.getExecutionTimePercentile(99.0)).append(" ");
                }
                return m.toString();
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

