/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;

public class CommandCollapserGetValueForKey
extends HystrixCollapser<List<String>, String, Integer> {
    private final Integer key;

    public CommandCollapserGetValueForKey(Integer key) {
        this.key = key;
    }

    public Integer getRequestArgument() {
        return this.key;
    }

    protected HystrixCommand<List<String>> createCommand(Collection<HystrixCollapser.CollapsedRequest<String, Integer>> requests) {
        return new BatchCommand(requests);
    }

    protected void mapResponseToRequests(List<String> batchResponse, Collection<HystrixCollapser.CollapsedRequest<String, Integer>> requests) {
        int count = 0;
        for (HystrixCollapser.CollapsedRequest<String, Integer> request : requests) {
            request.setResponse((Object)batchResponse.get(count++));
        }
    }

    public static class UnitTest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testCollapser() throws Exception {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                Future f1 = new CommandCollapserGetValueForKey(1).queue();
                Future f2 = new CommandCollapserGetValueForKey(2).queue();
                Future f3 = new CommandCollapserGetValueForKey(3).queue();
                Future f4 = new CommandCollapserGetValueForKey(4).queue();
                Assert.assertEquals((Object)"ValueForKey: 1", f1.get());
                Assert.assertEquals((Object)"ValueForKey: 2", f2.get());
                Assert.assertEquals((Object)"ValueForKey: 3", f3.get());
                Assert.assertEquals((Object)"ValueForKey: 4", f4.get());
                Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
                HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
                Assert.assertEquals((Object)"GetValueForKey", (Object)command.getCommandKey().name());
                Assert.assertTrue((boolean)command.getExecutionEvents().contains(HystrixEventType.COLLAPSED));
                Assert.assertTrue((boolean)command.getExecutionEvents().contains(HystrixEventType.SUCCESS));
            }
            finally {
                context.shutdown();
            }
        }
    }

    private static final class BatchCommand
    extends HystrixCommand<List<String>> {
        private final Collection<HystrixCollapser.CollapsedRequest<String, Integer>> requests;

        private BatchCommand(Collection<HystrixCollapser.CollapsedRequest<String, Integer>> requests) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup")).andCommandKey(HystrixCommandKey.Factory.asKey((String)"GetValueForKey")));
            this.requests = requests;
        }

        protected List<String> run() {
            ArrayList<String> response = new ArrayList<String>();
            for (HystrixCollapser.CollapsedRequest<String, Integer> request : this.requests) {
                response.add("ValueForKey: " + request.getArgument());
            }
            return response;
        }
    }
}

