/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import org.junit.Assert;
import org.junit.Test;

public class CommandWithFallbackViaNetwork
extends HystrixCommand<String> {
    private final int id;

    protected CommandWithFallbackViaNetwork(int id) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"RemoteServiceX")).andCommandKey(HystrixCommandKey.Factory.asKey((String)"GetValueCommand")));
        this.id = id;
    }

    protected String run() {
        throw new RuntimeException("force failure for example");
    }

    protected String getFallback() {
        return (String)new FallbackViaNetwork(this.id).execute();
    }

    public static class UnitTest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void test() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                Assert.assertEquals(null, (Object)new CommandWithFallbackViaNetwork(1).execute());
                HystrixCommand command1 = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[2])[1];
                Assert.assertEquals((Object)"GetValueCommand", (Object)command1.getCommandKey().name());
                Assert.assertTrue((boolean)command1.getExecutionEvents().contains(HystrixEventType.FAILURE));
                HystrixCommand command2 = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[2])[0];
                Assert.assertEquals((Object)"GetValueFallbackCommand", (Object)command2.getCommandKey().name());
                Assert.assertTrue((boolean)command2.getExecutionEvents().contains(HystrixEventType.FAILURE));
            }
            finally {
                context.shutdown();
            }
        }
    }

    private static class FallbackViaNetwork
    extends HystrixCommand<String> {
        private final int id;

        public FallbackViaNetwork(int id) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"RemoteServiceX")).andCommandKey(HystrixCommandKey.Factory.asKey((String)"GetValueFallbackCommand")).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)"RemoteServiceXFallback")));
            this.id = id;
        }

        protected String run() {
            throw new RuntimeException("the fallback also failed");
        }

        protected String getFallback() {
            return null;
        }
    }
}

