/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class CommandThatFailsFast
extends HystrixCommand<String> {
    private final boolean throwException;

    public CommandThatFailsFast(boolean throwException) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup"));
        this.throwException = throwException;
    }

    protected String run() {
        if (this.throwException) {
            throw new RuntimeException("failure from CommandThatFailsFast");
        }
        return "success";
    }

    public static class UnitTest {
        @Test
        public void testSuccess() {
            Assert.assertEquals((Object)"success", (Object)new CommandThatFailsFast(false).execute());
        }

        @Test
        public void testFailure() {
            try {
                new CommandThatFailsFast(true).execute();
                Assert.fail((String)"we should have thrown an exception");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertEquals((Object)"failure from CommandThatFailsFast", (Object)e.getCause().getMessage());
                e.printStackTrace();
            }
        }
    }
}

