/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.jetty;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.jetty.HollowDiffHandler;
import com.netflix.hollow.tools.diff.HollowDiff;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class HollowDiffUIServer {
    private final Server server;
    private final HollowDiffHandler handler;

    public HollowDiffUIServer() {
        this(8080);
    }

    public HollowDiffUIServer(int port) {
        this.server = new Server(port);
        this.handler = new HollowDiffHandler();
    }

    public HollowDiffUI addDiff(String diffPath, HollowDiff diff) {
        return this.addDiff(diffPath, diff, "FROM", "TO");
    }

    public HollowDiffUI addDiff(String diffPath, HollowDiff diff, String fromBlobName, String toBlobName) {
        return this.handler.getRouter().addDiff(diffPath, diff, fromBlobName, toBlobName);
    }

    public void start() throws Exception {
        this.server.setHandler((Handler)this.handler);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }
}

