/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class HollowUIRouter {
    protected final String baseUrlPath;
    protected final VelocityEngine velocityEngine;

    public HollowUIRouter(String baseUrlPath) {
        if (!baseUrlPath.startsWith("/")) {
            baseUrlPath = "/" + baseUrlPath;
        }
        if (baseUrlPath.endsWith("/")) {
            baseUrlPath = baseUrlPath.substring(0, baseUrlPath.length() - 1);
        }
        this.baseUrlPath = baseUrlPath;
        this.velocityEngine = this.initVelocity();
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public String getBaseURLPath() {
        return this.baseUrlPath;
    }

    protected String getTargetRootPath(String target) {
        int baseLength = this.baseUrlPath.length() + 1;
        if (target.length() < baseLength) {
            return "";
        }
        int secondSlashIndex = target.indexOf(47, baseLength);
        if (secondSlashIndex == -1) {
            return target.substring(baseLength);
        }
        return target.substring(baseLength, secondSlashIndex);
    }

    protected String getResourceName(String target) {
        int baseLength = this.baseUrlPath.length() + 1;
        int secondSlashIndex = target.indexOf(47, baseLength);
        if (secondSlashIndex == -1) {
            return "";
        }
        return target.substring(secondSlashIndex + 1);
    }

    protected boolean serveResource(HttpServletRequest req, HttpServletResponse resp, String resourceName) {
        try {
            if (req.getParameter("contentType") != null) {
                resp.setContentType(resourceName);
            }
            InputStream is = this.getClass().getResourceAsStream("/" + resourceName);
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected VelocityEngine initVelocity() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        ve.setProperty("runtime.log.logsystem.log4j.category", (Object)"velocity");
        ve.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        ve.init();
        return ve;
    }
}

