/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.HollowDiffViewRow;
import java.util.List;

public abstract class HollowObjectView {
    private static final int MAX_INITIAL_VISIBLE_ROWS_BEFORE_COLLAPSING_DIFFS = 300;
    private final List<HollowDiffViewRow> rows;

    public HollowObjectView(List<HollowDiffViewRow> rows) {
        this.rows = rows;
    }

    public List<HollowDiffViewRow> getRows() {
        return this.rows;
    }

    public void resetView() {
        boolean hasAnyDiff = false;
        for (HollowDiffViewRow row : this.rows) {
            if (row.getFieldPair().isDiff()) {
                row.setVisibleForPartialUnroll(true);
                row.setUnrolled(true);
                hasAnyDiff = true;
                continue;
            }
            if (!this.hasAnyDiffChildren(this.rows, row.getRowId(), false)) continue;
            row.setVisibleForPartialUnroll(true);
            if (this.hasAnyNonDiffChildren(this.rows, row.getRowId(), false)) {
                row.setPartiallyUnrolled(true);
                continue;
            }
            row.setUnrolled(true);
        }
        int visibleRows = 1 + this.countVisibleDescendents(this.rows, 0);
        if (visibleRows > 300) {
            for (HollowDiffViewRow row : this.rows) {
                if (!row.getFieldPair().isDiff()) continue;
                this.collapseSelfAndAllDescendents(this.rows, row.getRowId());
            }
        }
        if (!hasAnyDiff) {
            for (HollowDiffViewRow row : this.rows) {
                if (row.getFieldPair().isDiff()) {
                    row.setVisibleForPartialUnroll(true);
                    row.setUnrolled(true);
                    hasAnyDiff = true;
                    continue;
                }
                if (row.getFieldPair().getFromIdx() != row.getFieldPair().getToIdx()) {
                    row.setVisibleForPartialUnroll(true);
                    continue;
                }
                if (!this.hasAnyDiffChildren(this.rows, row.getRowId(), true)) continue;
                row.setVisibleForPartialUnroll(true);
                if (this.hasAnyNonDiffChildren(this.rows, row.getRowId(), true)) {
                    row.setPartiallyUnrolled(true);
                    continue;
                }
                row.setUnrolled(true);
            }
        }
    }

    private boolean hasAnyDiffChildren(List<HollowDiffViewRow> rows, int rowId, boolean showOrderingDiffs) {
        HollowDiffViewRow row = rows.get(rowId);
        for (int i = rowId + 1; i <= rowId + row.getNumDescendentRows(); ++i) {
            if (rows.get(i).getFieldPair().isDiff()) {
                return true;
            }
            if (!showOrderingDiffs || rows.get(i).getFieldPair().getFromIdx() == rows.get(i).getFieldPair().getToIdx()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNonDiffChildren(List<HollowDiffViewRow> rows, int rowId, boolean showOrderingDiffs) {
        HollowDiffViewRow parentRow = rows.get(rowId);
        if (parentRow.getFieldPair().isLeafNode()) {
            return false;
        }
        for (int i = rowId + 1; i <= rowId + parentRow.getNumDescendentRows(); ++i) {
            HollowDiffViewRow currentRow = rows.get(i);
            if (!(currentRow.getFieldPair().isDiff() || this.hasAnyDiffChildren(rows, i, showOrderingDiffs) || showOrderingDiffs && currentRow.getFieldPair().getFromIdx() != currentRow.getFieldPair().getToIdx())) {
                return true;
            }
            if (currentRow.getFieldPair().isLeafNode()) continue;
            i += currentRow.getNumDescendentRows();
        }
        return false;
    }

    private int countVisibleDescendents(List<HollowDiffViewRow> rows, int beginRowId) {
        HollowDiffViewRow parentRow = rows.get(beginRowId);
        int endRowId = beginRowId + rows.get(beginRowId).getNumDescendentRows();
        int visibleRows = 0;
        for (int i = beginRowId + 1; i < endRowId; ++i) {
            boolean rowIsVisible;
            HollowDiffViewRow currentRow = rows.get(i);
            boolean bl = rowIsVisible = parentRow.isUnrolled() || currentRow.isVisibleForPartialUnroll();
            if (rowIsVisible) {
                if (!currentRow.getFieldPair().isLeafNode() && (currentRow.isUnrolled() || currentRow.isPartiallyUnrolled())) {
                    visibleRows += this.countVisibleDescendents(rows, i);
                }
                ++visibleRows;
            }
            if (currentRow.getFieldPair().isLeafNode()) continue;
            i += currentRow.getNumDescendentRows();
        }
        return visibleRows;
    }

    private boolean collapseSelfAndAllDescendents(List<HollowDiffViewRow> rows, int rowId) {
        HollowDiffViewRow row = rows.get(rowId);
        for (int i = rowId; i <= rowId + row.getNumDescendentRows(); ++i) {
            rows.get(i).setUnrolled(false);
        }
        return false;
    }
}

