/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;

public class HollowDiffViewRow {
    private final HollowEffigyFieldPairer.EffigyFieldPair fieldPair;
    private final int indentation;
    private final int numDescendentRows;
    private final int rowId;
    private boolean unrolled;
    private boolean partiallyUnrolled;
    private boolean visibleForPartialUnroll;
    private final long moreFromRowsBits;
    private final long moreToRowsBits;

    public HollowDiffViewRow(HollowEffigyFieldPairer.EffigyFieldPair fieldPair, int rowId, int indentation, int numDescendentRows, boolean[] moreFromRows, boolean[] moreToRows) {
        this.fieldPair = fieldPair;
        this.indentation = indentation;
        this.numDescendentRows = numDescendentRows;
        this.rowId = rowId;
        long moreFromRowsBits = 0L;
        long moreToRowsBits = 0L;
        for (int i = 0; i <= indentation; ++i) {
            if (moreFromRows[i]) {
                moreFromRowsBits |= (long)(1 << i);
            }
            if (!moreToRows[i]) continue;
            moreToRowsBits |= (long)(1 << i);
        }
        this.moreFromRowsBits = moreFromRowsBits;
        this.moreToRowsBits = moreToRowsBits;
    }

    public HollowEffigyFieldPairer.EffigyFieldPair getFieldPair() {
        return this.fieldPair;
    }

    public int getRowId() {
        return this.rowId;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setUnrolled(boolean unrolled) {
        this.unrolled = unrolled;
    }

    public boolean isUnrolled() {
        return this.unrolled;
    }

    public void setPartiallyUnrolled(boolean partiallyUnrolled) {
        this.partiallyUnrolled = partiallyUnrolled;
    }

    public boolean isPartiallyUnrolled() {
        return this.partiallyUnrolled;
    }

    public void setVisibleForPartialUnroll(boolean visible) {
        this.visibleForPartialUnroll = visible;
    }

    public boolean isVisibleForPartialUnroll() {
        return this.visibleForPartialUnroll;
    }

    public int getNumDescendentRows() {
        return this.numDescendentRows;
    }

    public boolean hasMoreFromRows(int indentation) {
        return (this.moreFromRowsBits & (long)(1 << indentation)) != 0L;
    }

    public boolean hasMoreToRows(int indentation) {
        return (this.moreToRowsBits & (long)(1 << indentation)) != 0L;
    }
}

