/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.EVCacheLatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.internal.GenericCompletionListener;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheLatchImpl
implements EVCacheLatch {
    private static final Logger log = LoggerFactory.getLogger(EVCacheLatchImpl.class);
    private final int count;
    private final CountDownLatch latch;
    private final List<Future<Boolean>> futures;
    private final EVCacheLatch.Policy policy;
    private final String appName;

    public EVCacheLatchImpl(EVCacheLatch.Policy policy, int _count, String appName) {
        this.policy = policy;
        this.futures = new ArrayList<Future<Boolean>>(_count);
        this.appName = appName;
        this.count = this.policyToCount(policy, _count);
        this.latch = new CountDownLatch(this.count);
        if (log.isDebugEnabled()) {
            log.debug("Number of Futures = " + _count + "; Number of Futures that need to completed for Latch to be released = " + this.count);
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Current Latch Count = " + this.latch.getCount() + "; Will Start the wait");
        }
        return this.latch.await(timeout, unit);
    }

    public void addFuture(ListenableFuture<Boolean, OperationCompletionListener> future) {
        future.addListener((GenericCompletionListener)this);
        if (future.isDone()) {
            this.countDown();
        }
        this.futures.add((Future<Boolean>)future);
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public void countDown() {
        if (log.isDebugEnabled()) {
            log.debug("Current Latch Count = " + this.latch.getCount() + "; Count Down.");
        }
        this.latch.countDown();
    }

    @Override
    public int getPendingCount() {
        if (log.isDebugEnabled()) {
            log.debug("Pending Count = " + this.latch.getCount());
        }
        return (int)this.latch.getCount();
    }

    @Override
    public int getCompletedCount() {
        if (log.isDebugEnabled()) {
            log.debug("Completed Count = " + (this.count - (int)this.latch.getCount()));
        }
        return this.count - (int)this.latch.getCount();
    }

    @Override
    public List<Future<Boolean>> getPendingFutures() {
        ArrayList<Future<Boolean>> returnFutures = new ArrayList<Future<Boolean>>(this.count);
        for (Future<Boolean> future : this.futures) {
            if (future.isDone()) continue;
            returnFutures.add(future);
        }
        return returnFutures;
    }

    @Override
    public List<Future<Boolean>> getAllFutures() {
        return this.futures;
    }

    @Override
    public List<Future<Boolean>> getCompletedFutures() {
        ArrayList<Future<Boolean>> returnFutures = new ArrayList<Future<Boolean>>(this.count);
        for (Future<Boolean> future : this.futures) {
            if (!future.isDone()) continue;
            returnFutures.add(future);
        }
        return returnFutures;
    }

    private int policyToCount(EVCacheLatch.Policy policy, int count) {
        if (policy == null) {
            return 0;
        }
        switch (policy) {
            case NONE: {
                return 0;
            }
            case ONE: {
                return 1;
            }
            case QUORUM: {
                if (count == 0) {
                    return 0;
                }
                if (count <= 2) {
                    return 1;
                }
                return this.futures.size() / 2 + 1;
            }
            case ALL_MINUS_1: {
                if (count == 0) {
                    return 0;
                }
                if (count <= 2) {
                    return 1;
                }
                return count - 1;
            }
        }
        return count;
    }

    public void onComplete(OperationFuture<?> future) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("onComplete Callback. Calling Countdown. Completed Future = " + future);
        }
        this.countDown();
    }

    @Override
    public int getFailureCount() {
        int fail = 0;
        for (Future<Boolean> future : this.futures) {
            try {
                if (!future.isDone() || !future.get().equals(Boolean.FALSE)) continue;
                ++fail;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return fail;
    }

    @Override
    public int getExpectedSuccessCount() {
        return this.count;
    }

    @Override
    public int getSuccessCount() {
        int success = 0;
        for (Future<Boolean> future : this.futures) {
            try {
                if (!future.isDone() || !future.get().equals(Boolean.TRUE)) continue;
                ++success;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return success;
    }

    public String getAppName() {
        return this.appName;
    }

    @Override
    public EVCacheLatch.Policy getPolicy() {
        return this.policy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"AppName\":\"");
        builder.append(this.getAppName());
        builder.append("\",\"isDone\":\"");
        builder.append(this.isDone());
        builder.append("\",\"Pending Count\":\"");
        builder.append(this.getPendingCount());
        builder.append("\",\"Completed Count\":\"");
        builder.append(this.getCompletedCount());
        builder.append("\",\"Pending Futures\":\"");
        builder.append(this.getPendingFutures());
        builder.append("\",\"All Futures\":\"");
        builder.append(this.getAllFutures());
        builder.append("\",\"Completed Futures\":\"");
        builder.append(this.getCompletedFutures());
        builder.append("\",\"Failure Count\":\"");
        builder.append(this.getFailureCount());
        builder.append("\",\"Success Count\":\"");
        builder.append(this.getSuccessCount());
        builder.append("\"}");
        return builder.toString();
    }
}

