/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import java.util.Iterator;
import java.util.Set;

public class ZoneFallbackIterator {
    private Entry<String> entry;
    private int size = 0;

    public ZoneFallbackIterator(Set<String> allZones) {
        if (allZones == null || allZones.size() == 0) {
            return;
        }
        Entry<String> pEntry = null;
        Iterator<String> itr = allZones.iterator();
        while (itr.hasNext()) {
            ++this.size;
            String zone = itr.next();
            Entry<String> newEntry = new Entry<String>(zone, pEntry);
            if (this.entry == null) {
                this.entry = newEntry;
            }
            pEntry = newEntry;
        }
        if (pEntry != null) {
            ((Entry)this.entry).next = (Entry)pEntry;
        }
    }

    public String next() {
        if (this.entry == null) {
            return null;
        }
        this.entry = ((Entry)this.entry).next;
        return (String)((Entry)this.entry).element;
    }

    public String next(String ignoreZone) {
        if (this.entry == null) {
            return null;
        }
        this.entry = ((Entry)this.entry).next;
        if (((String)((Entry)this.entry).element).equals(ignoreZone)) {
            return (String)((Entry)this.entry).next.element;
        }
        return (String)((Entry)this.entry).element;
    }

    public int getSize() {
        return this.size;
    }

    static class Entry<E> {
        private E element;
        private Entry<E> next;

        Entry(E element, Entry<E> next) {
            this.element = element;
            this.next = next;
        }
    }
}

