/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ChainedDynamicProperty;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;

public class EVCacheKetamaNodeLocatorConfiguration
extends DefaultKetamaNodeLocatorConfiguration {
    private final String appId;
    private final ServerGroup serverGroup;
    private final EVCacheClientPoolManager poolManager;
    private final ChainedDynamicProperty.IntProperty bucketSize;
    private final ChainedDynamicProperty.BooleanProperty isSecure;

    public EVCacheKetamaNodeLocatorConfiguration(final String appId, ServerGroup serverGroup, final EVCacheClientPoolManager poolManager) {
        this.appId = appId;
        this.serverGroup = serverGroup;
        this.poolManager = poolManager;
        this.bucketSize = EVCacheConfig.getInstance().getChainedIntProperty(appId + "." + serverGroup.getName() + ".bucket.size", appId + ".bucket.size", super.getNodeRepetitions(), null);
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                poolManager.getEVCacheClientPool(appId).refreshPool();
            }
        };
        this.isSecure = EVCacheConfig.getInstance().getChainedBooleanProperty(this.serverGroup.getName() + ".is.secure", appId + ".is.secure", false, callback);
    }

    public int getNodeRepetitions() {
        return (Integer)this.bucketSize.get();
    }

    protected String getSocketAddressForNode(MemcachedNode node) {
        String result = (String)this.socketAddresses.get(node);
        if (result == null) {
            SocketAddress socketAddress = node.getSocketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                if (this.poolManager.getDiscoveryClient() != null) {
                    DiscoveryClient mgr = this.poolManager.getDiscoveryClient();
                    Application app = mgr.getApplication(this.appId);
                    if (app != null) {
                        List instances = app.getInstances();
                        for (InstanceInfo info : instances) {
                            String hostName = info.getHostName();
                            if (!hostName.equalsIgnoreCase(isa.getHostName())) continue;
                            String ip = info.getIPAddr();
                            String port = (String)info.getMetadata().get("evcache.port");
                            if (port == null) {
                                port = "11211";
                            }
                            if (((Boolean)this.isSecure.get()).booleanValue()) {
                                String securePort = (String)info.getMetadata().get("evcache.secure.port");
                                port = securePort == null ? "11443" : securePort;
                            }
                            result = hostName + '/' + ip + ':' + port;
                            break;
                        }
                    } else {
                        String port = (Boolean)this.isSecure.get() != false ? "11443" : "11211";
                        result = ((InetSocketAddress)socketAddress).getHostName() + '/' + ((InetSocketAddress)socketAddress).getAddress().getHostAddress() + ":" + port;
                    }
                } else {
                    String port = (Boolean)this.isSecure.get() != false ? "11443" : "11211";
                    result = ((InetSocketAddress)socketAddress).getHostName() + '/' + ((InetSocketAddress)socketAddress).getAddress().getHostAddress() + ":" + port;
                }
            } else {
                result = String.valueOf(socketAddress);
                if (result.startsWith("/")) {
                    result = result.substring(1);
                }
            }
            this.socketAddresses.put(node, result);
        }
        return result;
    }

    public String toString() {
        return "EVCacheKetamaNodeLocatorConfiguration [app=" + this.appId + ", ServerGroup=" + this.serverGroup + ", BucketSize=" + this.getNodeRepetitions() + "]";
    }
}

