/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ArchaiusType
implements ParameterizedType {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS;
    private final Class<?> rawType;
    private final Class<?>[] typeArguments;

    public static ParameterizedType forListOf(Class<?> listValuesType) {
        Class<?> maybeWrappedType = PRIMITIVE_WRAPPERS.getOrDefault(listValuesType, listValuesType);
        return new ArchaiusType(List.class, new Class[]{maybeWrappedType});
    }

    public static ParameterizedType forSetOf(Class<?> setValuesType) {
        Class<?> maybeWrappedType = PRIMITIVE_WRAPPERS.getOrDefault(setValuesType, setValuesType);
        return new ArchaiusType(Set.class, new Class[]{maybeWrappedType});
    }

    public static ParameterizedType forMapOf(Class<?> mapKeysTpe, Class<?> mapValuesType) {
        Class<?> maybeWrappedKeyType = PRIMITIVE_WRAPPERS.getOrDefault(mapKeysTpe, mapKeysTpe);
        Class<?> maybeWrappedValuesType = PRIMITIVE_WRAPPERS.getOrDefault(mapValuesType, mapValuesType);
        return new ArchaiusType(Map.class, new Class[]{maybeWrappedKeyType, maybeWrappedValuesType});
    }

    private ArchaiusType(Class<?> rawType, Class<?>[] typeArguments) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArguments = Objects.requireNonNull(typeArguments);
        if (rawType.isArray() || rawType.isPrimitive() || rawType.getTypeParameters().length != typeArguments.length) {
            throw new IllegalArgumentException("The provided rawType and arguments don't look like a supported parameterized type");
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    public String toString() {
        String typeArgumentNames = Arrays.stream(this.typeArguments).map(Class::getSimpleName).collect(Collectors.joining(","));
        return String.format("parameterizedType for %s<%s>", this.rawType.getSimpleName(), typeArgumentNames);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.rawType == null ? 0 : this.rawType.hashCode());
        result = 31 * result + Arrays.hashCode(this.typeArguments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchaiusType other = (ArchaiusType)obj;
        if (this.rawType == null && other.rawType != null) {
            return false;
        }
        if (this.rawType != null && !this.rawType.equals(other.rawType)) {
            return false;
        }
        if (this.typeArguments == null && other.typeArguments != null) {
            return false;
        }
        return this.typeArguments == null || Arrays.equals(this.typeArguments, other.typeArguments);
    }

    static {
        HashMap<Class<Object>, Class<Void>> wrappers = new HashMap<Class<Object>, Class<Void>>();
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Void.TYPE, Void.class);
        PRIMITIVE_WRAPPERS = Collections.unmodifiableMap(wrappers);
    }
}

