package com.netease.nimlib.log.sdk.util;

/**
 * Created by huangjun on 2017/9/20.
 */

public class WriteCheckCache {
    private static boolean hasChecked = false;
    private static boolean valid = false;

    /**
     * 是否需要重新检查
     *
     * @return true 需要重新检查，执行检查，并设置结果; false 已经检查过了，直接获取结果
     */
    public static boolean shouldReCheck() {
        return !hasChecked || !valid;
    }

    /**
     * 设置检查结果-有效
     */
    public static void setCheckValid() {
        valid = true;
        hasChecked = true;
    }

    /**
     * 设置检查结果-无效
     */
    public static void setCheckInvalid() {
        valid = false;
        hasChecked = true;
    }

    /**
     * 返回检查结果
     *
     * @return 检查结果，请保证已经做了检查并设置过结果
     */
    public static boolean isValid() {
        return valid;
    }
}
