package com.netease.nimlib.log.core;

import android.text.TextUtils;
import android.util.Log;

import com.netease.nimlib.log.sdk.LogBase;
import com.netease.nimlib.log.sdk.util.FileUtils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

/**
 * Created by huangjun on 2017/3/6.
 * 依据first EOF作为下次写入的起始位置
 */
@Deprecated
public class MMapWriter2 {
    private static final String TAG = "MMapWriter2";
    private static final boolean OUTPUT_LOG = true;
    private static final int K = 1024;
    private static final int M = 1024 * K;
    private static final int COPY_BUFFER_SIZE = M;
    private final int MAX_BUFFER_SIZE; // 8M
    private final int BASE_BUFFER_SIZE; // 4M
    private final int LAST_DANGEROUS_BUFFER_SIZE; // 2K
    private RandomAccessFile out;
    private MappedByteBuffer mappedByteBuffer;
    private File destFile;
    private String filePath;

    public MMapWriter2() {
        this(0, 0, 0);
    }

    public MMapWriter2(final int maxLength, final int baseLength, final int lastDangerousLength) {
        MAX_BUFFER_SIZE = (maxLength > 0 && maxLength > baseLength) ? maxLength : 8 * M;
        BASE_BUFFER_SIZE = (baseLength > 0 && baseLength < maxLength) ? baseLength : 4 * M;
        LAST_DANGEROUS_BUFFER_SIZE = (lastDangerousLength > 0 && lastDangerousLength < baseLength) ?
                lastDangerousLength : 2 * K;
    }

    public boolean open(final String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            return false;
        }

        if (checkValid()) {
            close();
        }

        try {
            // dest file
            File file = new File(filePath);
            this.filePath = filePath;
            this.destFile = file;
            File dirFile = file.getParentFile();
            if (dirFile == null) {
                log("file's parent dir is null, path=" + file.getCanonicalPath());
                return false;
            }

            // make dir
            if (dirFile.isDirectory() && !dirFile.exists()) {
                log("make dir, path=" + dirFile.getCanonicalPath() + ", result=" + dirFile.mkdirs());
            }

            // create new file
            if (!file.exists() && !file.createNewFile()) {
                log("can not create file, path=" + file.getCanonicalPath());
                return false;
            }

            // open
            log("try to open file, path=" + file.getCanonicalPath());
            out = new RandomAccessFile(file, "rw");
            if (out.length() <= 0) {
                out.setLength(MAX_BUFFER_SIZE);
            }

            // map
            mappedByteBuffer = out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0, MAX_BUFFER_SIZE);

            // offset
            int offset = moveToFirstEOF();

            // shrink
            offset = shrink(offset);

            // log
            log("open file success, path=" + file.getCanonicalPath() + ", offset=" + offset + ", length=" + file.length());
        } catch (IOException e) {
            e.printStackTrace();
            log("open file error, e=" + e.getMessage());
        }

        return true;
    }

    public void write(String content) {
        if (TextUtils.isEmpty(content)) {
            return;
        }

        if (destFile == null || !destFile.exists()) {
            log("dest file not exist reopen file");
            open(filePath);
        }

        // check status
        if (!checkValid()) {
            log("MMapWriter is invalid when do write");
            return;
        }

        byte[] bytes = null;
        try {
            bytes = content.getBytes("UTF8");
            for (int i = 0; i < bytes.length; i++) {
                if (bytes[i] == 0x00) {
                    bytes[i] = 0x20;
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        if (bytes == null) {
            return;
        }

        // check position
        int contentLength = bytes.length;
        int offset = mappedByteBuffer.position();
        if (offset >= MAX_BUFFER_SIZE - LAST_DANGEROUS_BUFFER_SIZE || offset + contentLength >= MAX_BUFFER_SIZE - 1) {
            log("mapped buffer has nearly used up, position=" + mappedByteBuffer.position()
                    + "/" + MAX_BUFFER_SIZE + ", will add " + contentLength + ", begin to shrink...");
            shrink(offset);
        }

        // write
        mappedByteBuffer.put(bytes);
        log("write position " + mappedByteBuffer.position() + "/" + MAX_BUFFER_SIZE + ", add " + contentLength);

        content = content.substring(0, contentLength - 2);
        log("write content : " + content);
    }

    public void close() {
        // force write
        if (mappedByteBuffer != null) {
            mappedByteBuffer.force();
            mappedByteBuffer.clear();
            mappedByteBuffer = null;
        }

        // file channel close
        FileUtils.close(out);

        // log
        log("file close success");
    }

    /**
     * 定位到可写位置
     */
    private int moveToFirstEOF() {
        int remainLength;
        int readLength;
        byte buf[] = null;
        final byte EOF = 0x00;
        int i;
        int offset = MAX_BUFFER_SIZE - 1;
        boolean find = false;
        while (!find && mappedByteBuffer.position() <= MAX_BUFFER_SIZE) {
            remainLength = MAX_BUFFER_SIZE - mappedByteBuffer.position();
            readLength = remainLength < COPY_BUFFER_SIZE ? remainLength : COPY_BUFFER_SIZE;

            // zero memory
            if (buf == null || buf.length != readLength) {
                buf = new byte[readLength];
            }

            // read check
            mappedByteBuffer.get(buf);
            for (i = 0; i < buf.length; i++) {
                if (buf[i] == EOF) {
                    find = true;
                    break;
                }
            }

            if (find) {
                offset = mappedByteBuffer.position() - buf.length + i;
            }
        }

        mappedByteBuffer.position(offset); // back to first NUL

        return offset;
    }

    /**
     * 文件裁剪
     */
    private int shrink(int offset) {
        // check status
        if (!checkValid()) {
            log("MMapWriter is invalid when do shrink");
            return offset;
        }

        if (offset < MAX_BUFFER_SIZE - LAST_DANGEROUS_BUFFER_SIZE) {
            return offset; // remain buffer is enough
        }

        // find first line start offset, max find 1K bytes
        int tempReadStart = MAX_BUFFER_SIZE - LAST_DANGEROUS_BUFFER_SIZE - BASE_BUFFER_SIZE;
        int readCount = 0;
        mappedByteBuffer.position(tempReadStart);
        while (true) {
            if (mappedByteBuffer.get() == '\r' && mappedByteBuffer.get() == '\n' || readCount > K) {
                break;
            }
            readCount++;
        }

        final int readStart = mappedByteBuffer.position();
        final int readEnd = offset - 1;
        int readPos = readStart;
        int writePos = 0;
        int readLength;
        int remainLength;

        mappedByteBuffer.position(readPos);
        byte buf[] = null;
        while (readPos <= readEnd) {
            // read
            remainLength = readEnd - readPos + 1;
            readLength = remainLength < COPY_BUFFER_SIZE ? remainLength : COPY_BUFFER_SIZE;
            if (buf == null || buf.length != readLength) {
                buf = new byte[readLength];
            }
            mappedByteBuffer.get(buf);
            readPos = mappedByteBuffer.position();

            // write
            mappedByteBuffer.position(writePos);
            mappedByteBuffer.put(buf);
            writePos = mappedByteBuffer.position();

            // prepare next read
            mappedByteBuffer.position(readPos);
        }

        // wipe remain space
        mappedByteBuffer.position(writePos);
        final byte b = 0x00;
        int writeLength;
        while (mappedByteBuffer.position() <= readEnd) {
            remainLength = readEnd - mappedByteBuffer.position() + 1;
            writeLength = remainLength < COPY_BUFFER_SIZE ? remainLength : COPY_BUFFER_SIZE;

            // zero memory
            if (buf == null || buf.length != writeLength) {
                buf = new byte[writeLength];
                Arrays.fill(buf, b);
            }

            // write
            mappedByteBuffer.put(buf);
        }

        // force
        mappedByteBuffer.force();

        // offset
        mappedByteBuffer.position(writePos);

        // log
        log("shrink file success, new offset=" + mappedByteBuffer.position());

        return mappedByteBuffer.position();
    }

    private boolean checkValid() {
        return out != null && mappedByteBuffer != null;
    }

    public void setDebugLog(LogBase log) {
        logBase = log;
    }

    private LogBase logBase;

    private void log(String content) {
        if (OUTPUT_LOG) {
            if (logBase != null) {
                logBase.i(TAG, content);
            } else {
                Log.i(TAG, content);
            }
        }
    }
}
