/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;

class Misc {
    private static final SecureRandom sRandom = new SecureRandom();

    private Misc() {
    }

    public static byte[] getBytesUTF8(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String toStringUTF8(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Misc.toStringUTF8(bytes, 0, bytes.length);
    }

    public static String toStringUTF8(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static byte[] nextBytes(byte[] buffer) {
        sRandom.nextBytes(buffer);
        return buffer;
    }

    public static byte[] nextBytes(int nBytes) {
        byte[] buffer = new byte[nBytes];
        return Misc.nextBytes(buffer);
    }

    public static String toOpcodeName(int opcode) {
        switch (opcode) {
            case 0: {
                return "CONTINUATION";
            }
            case 1: {
                return "TEXT";
            }
            case 2: {
                return "BINARY";
            }
            case 8: {
                return "CLOSE";
            }
            case 9: {
                return "PING";
            }
            case 10: {
                return "PONG";
            }
        }
        if (1 <= opcode && opcode <= 7) {
            return String.format("DATA(0x%X)", opcode);
        }
        if (8 <= opcode && opcode <= 15) {
            return String.format("CONTROL(0x%X)", opcode);
        }
        return String.format("0x%X", opcode);
    }
}

