/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.boot.interceptor;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class LauncherLaunchInterceptor
implements AroundInterceptor {
    private static final String PATH_SEPARATOR = "/";
    private static final String JAR_SEPARATOR = "!";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;

    public LauncherLaunchInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!this.validate(target, args)) {
            return;
        }
        String serviceName = this.createServiceName(target);
        URLClassLoader classLoader = (URLClassLoader)args[2];
        URL[] urls = classLoader.getURLs();
        ArrayList<String> loadedJarNames = new ArrayList<String>(this.extractLibJarNamesFromURLs(urls));
        ServerMetaDataHolder holder = this.traceContext.getServerMetaDataHolder();
        holder.addServiceInfo(serviceName, loadedJarNames);
        holder.notifyListeners();
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
    }

    private String createServiceName(Object target) {
        StringBuilder sb = new StringBuilder("Spring Boot");
        sb.append(" (").append(target.getClass().getSimpleName()).append(")");
        return sb.toString();
    }

    private boolean validate(Object target, Object[] args) {
        if (target == null || args == null) {
            return false;
        }
        if (args.length < 3) {
            return false;
        }
        return args[2] instanceof URLClassLoader;
    }

    private Set<String> extractLibJarNamesFromURLs(URL[] urls) {
        if (urls == null) {
            return Collections.emptySet();
        }
        TreeSet<String> libJarNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (URL url : urls) {
            try {
                String libJarName = this.extractLibJarName(url);
                if (libJarName.length() <= 0) continue;
                libJarNames.add(libJarName);
            }
            catch (Exception e) {
                this.logger.warn("Error extracting library name", (Throwable)e);
            }
        }
        return libJarNames;
    }

    private String extractLibJarName(URL url) {
        String protocol = url.getProtocol();
        String path = url.getPath().replaceAll("\\\\", PATH_SEPARATOR);
        if (protocol.equals("file")) {
            return this.extractNameFromFile(path);
        }
        if (protocol.equals("jar")) {
            return this.extractNameFromJar(path);
        }
        return "";
    }

    private String extractNameFromFile(String fileUri) {
        int lastIndexOfSeparator = fileUri.lastIndexOf(PATH_SEPARATOR);
        if (lastIndexOfSeparator < 0) {
            return fileUri;
        }
        return fileUri.substring(lastIndexOfSeparator + 1);
    }

    private String extractNameFromJar(String jarUri) {
        String uri = jarUri.substring(0, jarUri.lastIndexOf(JAR_SEPARATOR));
        int rootJarEndIndex = uri.indexOf(JAR_SEPARATOR);
        if (rootJarEndIndex < 0) {
            return this.extractNameFromFile(uri);
        }
        String rootJarFileUri = this.extractNameFromFile(uri.substring(0, rootJarEndIndex));
        StringBuilder sb = new StringBuilder(rootJarFileUri);
        sb.append(uri.substring(rootJarEndIndex));
        return sb.toString();
    }
}

