/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.boot;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.spring.boot.SpringBootConfiguration;
import com.navercorp.pinpoint.plugin.spring.boot.SpringBootConstants;
import com.navercorp.pinpoint.plugin.spring.boot.SpringBootDetector;
import com.navercorp.pinpoint.plugin.spring.boot.interceptor.LauncherLaunchInterceptor;
import java.security.ProtectionDomain;

public class SpringBootPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        SpringBootDetector springBootDetector;
        SpringBootConfiguration config = new SpringBootConfiguration(context.getConfig());
        if (!config.isSpringBootEnabled()) {
            this.logger.info("{} disabled", (Object)this.getClass().getSimpleName());
            return;
        }
        this.logger.info("{} config:{}", (Object)this.getClass().getSimpleName(), (Object)config);
        if (ServiceType.UNDEFINED.equals(context.getConfiguredApplicationType()) && (springBootDetector = new SpringBootDetector(config.getSpringBootBootstrapMains())).detect()) {
            this.logger.info("Detected application type : {}", (Object)SpringBootConstants.SERVICE_TYPE);
            if (!context.registerApplicationType(SpringBootConstants.SERVICE_TYPE)) {
                this.logger.info("Application type [{}] already set, skipping [{}] registration.", (Object)context.getApplicationType(), (Object)SpringBootConstants.SERVICE_TYPE);
            }
        }
        this.logger.info("Adding SpringBoot transformers");
        this.addLauncherEditor();
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private void addLauncherEditor() {
        this.transformTemplate.transform("org.springframework.boot.loader.Launcher", LauncherTransform.class);
    }

    public static class LauncherTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod method = target.getDeclaredMethod("launch", new String[]{"java.lang.String[]", "java.lang.String", "java.lang.ClassLoader"});
            if (method != null) {
                method.addInterceptor(LauncherLaunchInterceptor.class);
            }
            return target.toBytecode();
        }
    }
}

