/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

public final class Token {
    private int type;
    private int line;
    private int column;
    private Object value;
    private String text;
    public static final int AND_EQ = 257;
    public static final int ARROW = 258;
    public static final int CHARACTER = 259;
    public static final int CCOMMENT = 260;
    public static final int CPPCOMMENT = 261;
    public static final int DEC = 262;
    public static final int DIV_EQ = 263;
    public static final int ELLIPSIS = 264;
    public static final int EOF = 265;
    public static final int EQ = 266;
    public static final int GE = 267;
    public static final int HASH = 268;
    public static final int HEADER = 269;
    public static final int IDENTIFIER = 270;
    public static final int INC = 271;
    public static final int INTEGER = 272;
    public static final int LAND = 273;
    public static final int LAND_EQ = 274;
    public static final int LE = 275;
    public static final int LITERAL = 276;
    public static final int LOR = 277;
    public static final int LOR_EQ = 278;
    public static final int LSH = 279;
    public static final int LSH_EQ = 280;
    public static final int MOD_EQ = 281;
    public static final int MULT_EQ = 282;
    public static final int NE = 283;
    public static final int NL = 284;
    public static final int OR_EQ = 285;
    public static final int PASTE = 286;
    public static final int PLUS_EQ = 287;
    public static final int RANGE = 288;
    public static final int RSH = 289;
    public static final int RSH_EQ = 290;
    public static final int STRING = 291;
    public static final int SUB_EQ = 292;
    public static final int WHITESPACE = 293;
    public static final int XOR_EQ = 294;
    public static final int M_ARG = 295;
    public static final int M_PASTE = 296;
    public static final int M_STRING = 297;
    public static final int P_LINE = 298;
    public static final int INVALID = 299;
    public static final int _TOKENS = 300;
    static final Token space = new Token(293, -1, -1, " ");
    private static final String[] names = new String[300];
    private static final String[] texts = new String[300];

    public Token(int type, int line, int column, String text, Object value) {
        this.type = type;
        this.line = line;
        this.column = column;
        this.text = text;
        this.value = value;
    }

    public Token(int type, int line, int column, String text) {
        this(type, line, column, text, null);
    }

    Token(int type, String text, Object value) {
        this(type, -1, -1, text, value);
    }

    Token(int type, String text) {
        this(type, text, null);
    }

    Token(int type) {
        this(type, type < 300 ? texts[type] : "TOK" + type);
    }

    public int getType() {
        return this.type;
    }

    void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(Token.getTokenName(this.type));
        if (this.line != -1) {
            buf.append('@').append(this.line);
            if (this.column != -1) {
                buf.append(',').append(this.column);
            }
        }
        buf.append("]:");
        if (this.text != null) {
            buf.append('\"').append(this.text).append('\"');
        } else if (this.type > 3 && this.type < 256) {
            buf.append((char)this.type);
        } else {
            buf.append('<').append(this.type).append('>');
        }
        if (this.value != null) {
            buf.append('=').append(this.value);
        }
        return buf.toString();
    }

    public static final String getTokenName(int type) {
        if (type < 0) {
            return "Invalid" + type;
        }
        if (type >= names.length) {
            return "Invalid" + type;
        }
        if (names[type] == null) {
            return "Unknown" + type;
        }
        return names[type];
    }

    static {
        for (int i = 0; i < 255; ++i) {
            Token.texts[i] = String.valueOf(new char[]{(char)i});
            Token.names[i] = texts[i];
        }
        Token.texts[257] = "&=";
        Token.texts[258] = "->";
        Token.texts[262] = "--";
        Token.texts[263] = "/=";
        Token.texts[264] = "...";
        Token.texts[266] = "==";
        Token.texts[267] = ">=";
        Token.texts[268] = "#";
        Token.texts[271] = "++";
        Token.texts[273] = "&&";
        Token.texts[274] = "&&=";
        Token.texts[275] = "<=";
        Token.texts[277] = "||";
        Token.texts[278] = "||=";
        Token.texts[279] = "<<";
        Token.texts[280] = "<<=";
        Token.texts[281] = "%=";
        Token.texts[282] = "*=";
        Token.texts[283] = "!=";
        Token.texts[284] = "\n";
        Token.texts[285] = "|=";
        Token.texts[286] = "##";
        Token.texts[287] = "+=";
        Token.texts[288] = "..";
        Token.texts[289] = ">>";
        Token.texts[290] = ">>=";
        Token.texts[292] = "-=";
        Token.texts[294] = "^=";
        Token.names[257] = "AND_EQ";
        Token.names[258] = "ARROW";
        Token.names[259] = "CHARACTER";
        Token.names[260] = "CCOMMENT";
        Token.names[261] = "CPPCOMMENT";
        Token.names[262] = "DEC";
        Token.names[263] = "DIV_EQ";
        Token.names[264] = "ELLIPSIS";
        Token.names[265] = "EOF";
        Token.names[266] = "EQ";
        Token.names[267] = "GE";
        Token.names[268] = "HASH";
        Token.names[269] = "HEADER";
        Token.names[270] = "IDENTIFIER";
        Token.names[271] = "INC";
        Token.names[272] = "INTEGER";
        Token.names[273] = "LAND";
        Token.names[274] = "LAND_EQ";
        Token.names[275] = "LE";
        Token.names[276] = "LITERAL";
        Token.names[277] = "LOR";
        Token.names[278] = "LOR_EQ";
        Token.names[279] = "LSH";
        Token.names[280] = "LSH_EQ";
        Token.names[281] = "MOD_EQ";
        Token.names[282] = "MULT_EQ";
        Token.names[283] = "NE";
        Token.names[284] = "NL";
        Token.names[285] = "OR_EQ";
        Token.names[286] = "PASTE";
        Token.names[287] = "PLUS_EQ";
        Token.names[288] = "RANGE";
        Token.names[289] = "RSH";
        Token.names[290] = "RSH_EQ";
        Token.names[291] = "STRING";
        Token.names[292] = "SUB_EQ";
        Token.names[293] = "WHITESPACE";
        Token.names[294] = "XOR_EQ";
        Token.names[295] = "M_ARG";
        Token.names[296] = "M_PASTE";
        Token.names[297] = "M_STRING";
        Token.names[298] = "P_LINE";
        Token.names[299] = "INVALID";
    }
}

