/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.anarres.cpp.Argument;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Macro;
import org.anarres.cpp.Source;
import org.anarres.cpp.SourceIterator;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MacroTokenSource
extends Source {
    private Macro macro;
    private Iterator<Token> tokens;
    private List<Argument> args;
    private Iterator<Token> arg;

    MacroTokenSource(Macro m, List<Argument> args) {
        this.macro = m;
        this.tokens = m.getTokens().iterator();
        this.args = args;
        this.arg = null;
    }

    @Override
    boolean isExpanding(Macro m) {
        if (this.macro == m) {
            return true;
        }
        return super.isExpanding(m);
    }

    static void escape(StringBuilder buf, CharSequence cs) {
        block6: for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    continue block6;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block6;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block6;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block6;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    private void concat(StringBuilder buf, Argument arg) {
        for (Token tok : arg) {
            buf.append(tok.getText());
        }
    }

    private Token stringify(Token pos, Argument arg) {
        StringBuilder buf = new StringBuilder();
        this.concat(buf, arg);
        StringBuilder str = new StringBuilder("\"");
        MacroTokenSource.escape(str, buf);
        str.append("\"");
        return new Token(291, pos.getLine(), pos.getColumn(), str.toString(), buf.toString());
    }

    private void paste(Token ptok) throws IOException, LexerException {
        StringBuilder buf = new StringBuilder();
        Object err = null;
        int count = 2;
        block5: for (int i = 0; i < count; ++i) {
            if (!this.tokens.hasNext()) {
                this.error(ptok.getLine(), ptok.getColumn(), "Paste at end of expansion");
                buf.append(' ').append(ptok.getText());
                break;
            }
            Token tok = this.tokens.next();
            switch (tok.getType()) {
                case 296: {
                    count += 2;
                    ptok = tok;
                    continue block5;
                }
                case 295: {
                    int idx = (Integer)tok.getValue();
                    this.concat(buf, this.args.get(idx));
                    continue block5;
                }
                case 260: 
                case 261: {
                    continue block5;
                }
                default: {
                    buf.append(tok.getText());
                }
            }
        }
        StringLexerSource sl = new StringLexerSource(buf.toString());
        this.arg = new SourceIterator(sl);
    }

    @Override
    public Token token() throws IOException, LexerException {
        Token tok;
        block5: while (true) {
            if (this.arg != null) {
                if (this.arg.hasNext()) {
                    tok = this.arg.next();
                    assert (tok.getType() != 296) : "Unexpected paste token";
                    return tok;
                }
                this.arg = null;
            }
            if (!this.tokens.hasNext()) {
                return new Token(265, -1, -1, "");
            }
            tok = this.tokens.next();
            switch (tok.getType()) {
                case 297: {
                    int idx = (Integer)tok.getValue();
                    return this.stringify(tok, this.args.get(idx));
                }
                case 295: {
                    int idx = (Integer)tok.getValue();
                    this.arg = this.args.get(idx).expansion();
                    continue block5;
                }
                case 296: {
                    this.paste(tok);
                    continue block5;
                }
            }
            break;
        }
        return tok;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("expansion of ").append(this.macro.getName());
        Source parent = this.getParent();
        if (parent != null) {
            buf.append(" in ").append(String.valueOf(parent));
        }
        return buf.toString();
    }
}

