/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.anarres.cpp.Source;
import org.anarres.cpp.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Macro {
    private Source source;
    private String name;
    private List<String> args;
    private boolean variadic;
    private List<Token> tokens;

    public Macro(Source source, String name) {
        this.source = source;
        this.name = name;
        this.args = null;
        this.variadic = false;
        this.tokens = new ArrayList<Token>();
    }

    public Macro(String name) {
        this(null, name);
    }

    public void setSource(Source s) {
        this.source = s;
    }

    public Source getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public boolean isFunctionLike() {
        return this.args != null;
    }

    public int getArgs() {
        return this.args.size();
    }

    public void setVariadic(boolean b) {
        this.variadic = b;
    }

    public boolean isVariadic() {
        return this.variadic;
    }

    public void addToken(Token tok) {
        this.tokens.add(tok);
    }

    public void addPaste(Token tok) {
        this.tokens.add(this.tokens.size() - 1, tok);
    }

    List<Token> getTokens() {
        return this.tokens;
    }

    public String getText() {
        StringBuilder buf = new StringBuilder();
        boolean paste = false;
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token tok = this.tokens.get(i);
            if (tok.getType() == 296) {
                assert (!paste) : "Two sequential pastes.";
                paste = true;
                continue;
            }
            buf.append(tok.getText());
            if (!paste) continue;
            buf.append(" ## ");
            paste = false;
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name);
        if (this.args != null) {
            buf.append('(');
            Iterator<String> it = this.args.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (it.hasNext()) {
                    buf.append(", ");
                    continue;
                }
                if (!this.isVariadic()) continue;
                buf.append("...");
            }
            buf.append(')');
        }
        if (!this.tokens.isEmpty()) {
            buf.append(" => ").append(this.getText());
        }
        return buf.toString();
    }
}

