/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength.converter;

import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.core.util.StringUtil;

public class FillerConverter
implements FieldConvert.FieldConverter<Annotation> {
    private final char fillChar;

    public FillerConverter(char fillChar) {
        this.fillChar = fillChar;
    }

    @Override
    public void initialize(Annotation annotation) {
    }

    @Override
    public Object convertOfRead(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, byte[] input) {
        return new String(input, fixedLengthDataBindConfig.getCharset());
    }

    @Override
    public byte[] convertOfWrite(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, Object output) {
        byte[] bytes = StringUtil.getBytes((String)Character.toString(this.fillChar), (Charset)fixedLengthDataBindConfig.getCharset());
        ByteBuffer buffer = ByteBuffer.allocate(fieldConfig.getLength());
        while (buffer.position() < buffer.limit()) {
            buffer.put(bytes);
        }
        return buffer.array();
    }
}

