/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.LayoutBuilderSupport;
import nablarch.common.databind.fixedlength.MultiLayoutConfig;
import nablarch.common.databind.fixedlength.RecordConfig;
import nablarch.common.databind.fixedlength.converter.DefaultConverter;
import nablarch.core.util.annotation.Published;

public class MultiLayoutBuilder
extends LayoutBuilderSupport {
    private MultiLayoutConfig.RecordIdentifier recordIdentifier;
    private final Map<String, List<FieldConfig>> fieldConfigMap = new HashMap<String, List<FieldConfig>>();
    private String recordName;

    public MultiLayoutBuilder(int length, Charset charset, String lineSeparator, char fillChar) {
        super(length, charset, lineSeparator, fillChar);
    }

    @Override
    @Published
    public MultiLayoutBuilder field(String name, int offset, int length) {
        return this.field(name, offset, length, new DefaultConverter());
    }

    @Override
    @Published
    public MultiLayoutBuilder field(String name, int offset, int length, FieldConvert.FieldConverter converter) {
        if (this.recordName == null) {
            throw new IllegalStateException("must be calling record method before calling field method.");
        }
        this.fieldConfigMap.get(this.recordName).add(new FieldConfig(name, offset, length, converter));
        return this;
    }

    @Published
    public MultiLayoutBuilder record(String name) {
        this.fieldConfigMap.put(name, new ArrayList());
        this.recordName = name;
        return this;
    }

    @Published
    public MultiLayoutBuilder recordIdentifier(MultiLayoutConfig.RecordIdentifier recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
        return this;
    }

    @Override
    @Published
    public FixedLengthDataBindConfig build() {
        if (this.recordIdentifier == null) {
            throw new IllegalStateException("record identifier is undefined.");
        }
        HashMap<String, RecordConfig> recordConfigMap = new HashMap<String, RecordConfig>();
        for (Map.Entry<String, List<FieldConfig>> entry : this.fieldConfigMap.entrySet()) {
            this.addFillerFieldConfig(entry.getValue());
            recordConfigMap.put(entry.getKey(), new RecordConfig(entry.getKey(), entry.getValue()));
        }
        this.verifyFile();
        this.verifyRecordConfig(recordConfigMap);
        return new FixedLengthDataBindConfig(this.length, this.charset, this.lineSeparator, this.fillChar, recordConfigMap, new MultiLayoutConfig(this.recordIdentifier));
    }
}

