/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.RecordConfig;
import nablarch.common.databind.fixedlength.converter.FillerConverter;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

public abstract class LayoutBuilderSupport {
    protected final int length;
    protected final Charset charset;
    protected final String lineSeparator;
    protected final char fillChar;

    public LayoutBuilderSupport(int length, Charset charset, String lineSeparator, char fillChar) {
        this.length = length;
        this.charset = charset;
        this.lineSeparator = lineSeparator;
        this.fillChar = fillChar;
    }

    @Published
    public abstract LayoutBuilderSupport field(String var1, int var2, int var3);

    @Published
    public abstract LayoutBuilderSupport field(String var1, int var2, int var3, FieldConvert.FieldConverter var4);

    @Published
    public abstract FixedLengthDataBindConfig build();

    protected void addFillerFieldConfig(List<FieldConfig> fieldConfigList) {
        Collections.sort(fieldConfigList, new FieldConfigComparator());
        ArrayList<FieldConfig> fillers = new ArrayList<FieldConfig>();
        int position = 1;
        for (FieldConfig fieldConfig : fieldConfigList) {
            int fillSize = fieldConfig.getOffset() - position;
            if (fillSize > 0) {
                fillers.add(new FieldConfig("filler", position, fillSize, new FillerConverter(this.fillChar)));
            }
            position = fieldConfig.getOffset() + fieldConfig.getLength();
        }
        int fillSize = this.length + 1 - position;
        if (fillSize > 0) {
            fillers.add(new FieldConfig("filler", position, fillSize, new FillerConverter(this.fillChar)));
        }
        fieldConfigList.addAll(fillers);
        Collections.sort(fieldConfigList, new FieldConfigComparator());
    }

    protected void verifyFile() {
        if (this.length <= 0) {
            throw new IllegalStateException("length is invalid. must set greater than 0.");
        }
        byte[] bytes = StringUtil.getBytes((String)Character.toString(this.fillChar), (Charset)this.charset);
        if (bytes.length != 1) {
            throw new IllegalStateException("fillChar is invalid. must be single byte character.");
        }
    }

    protected void verifyRecordConfig(Map<String, RecordConfig> recordConfigMap) {
        for (Map.Entry<String, RecordConfig> entry : recordConfigMap.entrySet()) {
            String recordName = entry.getKey();
            RecordConfig recordConfig = entry.getValue();
            int expectedOffset = 1;
            FieldConfig lastField = null;
            for (FieldConfig fieldConfig : recordConfig.getFieldConfigList()) {
                if ("filler".equals(fieldConfig.getName())) continue;
                if (expectedOffset > fieldConfig.getOffset()) {
                    throw new IllegalStateException("field offset is invalid. record_name:" + recordName + ", field_name:" + fieldConfig.getName() + ", expected offset:" + expectedOffset + " but was " + fieldConfig.getOffset());
                }
                expectedOffset += fieldConfig.getLength();
                lastField = fieldConfig;
            }
            if (lastField == null) {
                throw new IllegalStateException("field was not found. record_name:" + recordName);
            }
            if (this.length >= lastField.getOffset() + lastField.getLength() - 1) continue;
            throw new IllegalStateException("field length is invalid. record_name:" + recordName + ", field_name:" + lastField.getName() + ", expected length:" + (this.length - lastField.getOffset() + 1) + " but was " + lastField.getLength());
        }
    }

    protected static class FieldConfigComparator
    implements Comparator<FieldConfig> {
        protected FieldConfigComparator() {
        }

        @Override
        public int compare(FieldConfig o1, FieldConfig o2) {
            int second;
            int first = o1.getOffset();
            if (first < (second = o2.getOffset())) {
                return -1;
            }
            if (first > second) {
                return 1;
            }
            return 0;
        }
    }
}

