/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.MultiLayoutConfig;

public class FixedLengthWriter
implements Closeable {
    private final WritableByteChannel writableByteChannel;
    private final FixedLengthDataBindConfig config;
    private final ByteBuffer lineSeparatorByteBuffer;

    public FixedLengthWriter(OutputStream stream, FixedLengthDataBindConfig config) {
        this.writableByteChannel = Channels.newChannel(stream);
        this.lineSeparatorByteBuffer = ByteBuffer.allocate(config.getLineSeparator().length());
        this.lineSeparatorByteBuffer.put(config.getLineSeparator().getBytes(config.getCharset()));
        this.config = config;
    }

    public void writeRecord(Map<String, ?> map) {
        List<FieldConfig> fieldConfigList;
        Map fields;
        int configLength = this.config.getLength();
        if (this.config.isMultiLayout()) {
            MultiLayoutConfig.RecordName recordName = (MultiLayoutConfig.RecordName)map.get("recordName");
            try {
                fields = (Map)map.get(recordName.getRecordName());
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("record data must be " + Map.class.getName() + " type.", e);
            }
            if (fields == null) {
                throw new IllegalArgumentException("record data is not found. record_name:" + recordName.getRecordName());
            }
            fieldConfigList = this.config.getRecordConfig(recordName.getRecordName()).getFieldConfigList();
        } else {
            fields = map;
            fieldConfigList = this.config.getRecordConfig("single").getFieldConfigList();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(configLength);
        for (FieldConfig fieldConfig : fieldConfigList) {
            byte[] value = fieldConfig.getFieldConverter().convertOfWrite(this.config, fieldConfig, fields.get(fieldConfig.getName()));
            try {
                byteBuffer.put(value);
            }
            catch (BufferOverflowException e) {
                throw new IllegalArgumentException("record length is invalid. expected_length:" + configLength + ", actual_length:" + (byteBuffer.position() + value.length), e);
            }
        }
        this.write(byteBuffer);
        this.write(this.lineSeparatorByteBuffer);
    }

    private void write(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        try {
            this.writableByteChannel.write(byteBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writableByteChannel.close();
    }
}

