/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.fixedlength.MultiLayoutConfig;
import nablarch.common.databind.fixedlength.RecordConfig;

public class FixedLengthDataBindConfig
implements DataBindConfig {
    private final int length;
    private final Charset charset;
    private final String lineSeparator;
    private final char fillChar;
    private final Map<String, RecordConfig> recordConfigs;
    private MultiLayoutConfig multiLayoutConfig;

    public FixedLengthDataBindConfig(int length, Charset charset, String lineSeparator, char fillChar, Map<String, RecordConfig> recordConfigs, MultiLayoutConfig multiLayoutConfig) {
        this.length = length;
        this.charset = charset;
        this.lineSeparator = lineSeparator;
        this.fillChar = fillChar;
        this.recordConfigs = Collections.unmodifiableMap(recordConfigs);
        this.multiLayoutConfig = multiLayoutConfig;
    }

    public FixedLengthDataBindConfig(int length, Charset charset, String lineSeparator, char fillChar, Map<String, RecordConfig> recordConfigs) {
        this.length = length;
        this.charset = charset;
        this.lineSeparator = lineSeparator;
        this.fillChar = fillChar;
        this.recordConfigs = Collections.unmodifiableMap(recordConfigs);
    }

    public int getLength() {
        return this.length;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public char getFillChar() {
        return this.fillChar;
    }

    public RecordConfig getRecordConfig(String recordName) {
        return this.recordConfigs.get(recordName);
    }

    public boolean isMultiLayout() {
        return this.multiLayoutConfig != null;
    }

    public MultiLayoutConfig getMultiLayoutConfig() {
        return this.multiLayoutConfig;
    }
}

