/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import nablarch.common.databind.ObjectMapper;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.MapFixedLengthMapper;
import nablarch.common.databind.fixedlength.MultiLayoutConfig;
import nablarch.core.beans.BeanUtil;

public class BeanFixedLengthMapper<T>
implements ObjectMapper<T> {
    private final FixedLengthDataBindConfig config;
    private final MapFixedLengthMapper mapFixedLengthMapper;

    public BeanFixedLengthMapper(Class<T> clazz, FixedLengthDataBindConfig config, OutputStream stream) {
        this.config = config;
        this.mapFixedLengthMapper = new MapFixedLengthMapper(config, stream);
    }

    @Override
    public void write(T object) {
        HashMap<String, Object> map;
        if (this.config.isMultiLayout()) {
            MultiLayoutConfig.RecordName recordName = (MultiLayoutConfig.RecordName)BeanUtil.getProperty(object, (String)"recordName");
            Object record = BeanUtil.getProperty(object, (String)recordName.getRecordName());
            map = new HashMap<String, Object>();
            map.put("recordName", recordName);
            if (record != null) {
                map.put(recordName.getRecordName(), BeanUtil.createMapAndCopy((Object)record));
            }
        } else {
            map = BeanUtil.createMapAndCopy(object);
        }
        this.mapFixedLengthMapper.write((Map<String, ?>)map);
    }

    @Override
    public T read() {
        throw new UnsupportedOperationException("unsupported read method.");
    }

    @Override
    public void close() {
        this.mapFixedLengthMapper.close();
    }
}

