/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import nablarch.common.databind.ObjectMapper;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvDataWriter;
import nablarch.core.util.FileUtil;

public abstract class ObjectCsvMapperSupport<T>
implements ObjectMapper<T> {
    protected final CsvDataBindConfig config;
    private final CsvDataWriter writer;

    public ObjectCsvMapperSupport(CsvDataBindConfig config, Writer writer) {
        this.config = config;
        this.writer = new CsvDataWriter(ObjectCsvMapperSupport.toBufferedWriter(writer), config, config.getKeys());
    }

    protected void writeHeader() {
        if (!this.config.isRequiredHeader()) {
            return;
        }
        try {
            this.writer.write(this.config.getHeaderTitles());
        }
        catch (IOException e) {
            throw new RuntimeException("failed to writer header.", e);
        }
    }

    private static BufferedWriter toBufferedWriter(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Override
    public T read() {
        throw new UnsupportedOperationException("unsupported read method.");
    }

    @Override
    public void write(T object) {
        try {
            this.writer.write(this.convertValues(object));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write.", e);
        }
    }

    protected abstract Object[] convertValues(T var1);

    @Override
    public void close() {
        FileUtil.closeQuietly((Closeable[])new Closeable[]{this.writer});
    }
}

