/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import nablarch.common.databind.InvalidDataFormatException;
import nablarch.common.databind.csv.CsvDataBindConfig;

class CsvTokenizer {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CR_STR = String.valueOf('\r');
    private static final String LF_STR = String.valueOf('\n');
    private static final String CRLF = "\r\n";
    private final ExtendedReader reader;
    private final CsvDataBindConfig format;
    private boolean hasNext = true;

    public CsvTokenizer(BufferedReader reader, CsvDataBindConfig format) {
        this.reader = new ExtendedReader(reader);
        this.format = format;
    }

    public String next() throws IOException {
        int c = this.reader.read();
        if (this.isEndOfFile(c) || this.isEndOfLine(c)) {
            this.hasNext = false;
            return this.format.isEmptyToNull() ? null : "";
        }
        if (this.isFieldSeparator(c)) {
            return this.format.isEmptyToNull() ? null : "";
        }
        if (this.isQuote(c)) {
            return this.readQuotedItem();
        }
        return this.readItem((char)c);
    }

    private String readQuotedItem() throws IOException {
        StringBuilder sb = new StringBuilder(256);
        long startLine = this.reader.getLineNumber();
        while (true) {
            int c;
            if (this.isQuote(c = this.reader.read())) {
                int nextChar = this.reader.read();
                if (this.isQuote(nextChar)) {
                    sb.append((char)c);
                    continue;
                }
                if (this.isEndOfLine(nextChar) || this.isEndOfFile(nextChar)) {
                    this.hasNext = false;
                    break;
                }
                if (this.isFieldSeparator(nextChar)) break;
                throw new InvalidDataFormatException("unescaped quote character.", this.reader.getLineNumber());
            }
            if (this.isEndOfFile(c)) {
                throw new InvalidDataFormatException("EOF reached before quoted token finished.", startLine);
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private String readItem(char c) throws IOException {
        this.checkValidChar(c);
        StringBuilder sb = new StringBuilder(256);
        sb.append(c);
        while (true) {
            int nextChar;
            if (this.isEndOfFile(nextChar = this.reader.read()) || this.isEndOfLine(nextChar)) {
                this.hasNext = false;
                break;
            }
            if (this.isFieldSeparator(nextChar)) break;
            this.checkValidChar(nextChar);
            sb.append((char)nextChar);
        }
        return sb.toString();
    }

    private void checkValidChar(int c) throws IOException {
        if (this.isQuote(c)) {
            throw new InvalidDataFormatException("invalid quote character.", this.reader.getLineNumber());
        }
        if (c == 10 || c == 13) {
            throw new InvalidDataFormatException("invalid line separator.", this.reader.getLineNumber());
        }
    }

    private boolean isQuote(int c) {
        return c == this.format.getQuote();
    }

    private boolean isFieldSeparator(int c) {
        return c == this.format.getFieldSeparator();
    }

    private boolean isEndOfFile(int c) {
        return c == -1;
    }

    public boolean isEndOfFile() throws IOException {
        return this.reader.readNextCharAndReset() == -1;
    }

    private boolean isEndOfLine(int c) throws IOException {
        String separator = this.format.getLineSeparator();
        if (c == 10) {
            return separator.equals(LF_STR);
        }
        if (c == 13) {
            if (this.reader.readNextCharAndReset() == 10) {
                if (separator.equals(CRLF)) {
                    this.reader.read();
                    return true;
                }
            } else {
                return separator.equals(CR_STR);
            }
        }
        return false;
    }

    public boolean isEndOfLine() {
        return !this.hasNext;
    }

    public void reset() {
        this.hasNext = true;
    }

    public long getLineNumber() {
        return this.reader.getLineNumber();
    }

    private static class ExtendedReader
    extends BufferedReader {
        private long lineNumber = 1L;
        private int lastChar = -1;

        public ExtendedReader(Reader in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int read = super.read();
            if (this.isLineSeparator(read)) {
                ++this.lineNumber;
            }
            if (read != -1) {
                this.lastChar = read;
            }
            return read;
        }

        private boolean isLineSeparator(int c) throws IOException {
            if (c == 10) {
                return true;
            }
            return c == 13 && this.readNextCharAndReset() != 10;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException("unsupported.");
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            throw new UnsupportedOperationException("unsupported.");
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            throw new UnsupportedOperationException("unsupported.");
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException("unsupported.");
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException("unsupported.");
        }

        private int readNextCharAndReset() throws IOException {
            this.mark(1);
            int c = super.read();
            this.reset();
            return c;
        }

        public long getLineNumber() {
            try {
                return this.isLineSeparator(this.lastChar) ? this.lineNumber - 1L : this.lineNumber;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

