/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import nablarch.common.databind.ObjectMapper;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvDataReader;
import nablarch.core.util.FileUtil;
import nablarch.core.util.StringUtil;

public abstract class CsvObjectMapperSupport<T>
implements ObjectMapper<T> {
    protected final CsvDataBindConfig config;
    protected final CsvDataReader reader;

    public CsvObjectMapperSupport(CsvDataBindConfig config, Reader reader) {
        this.config = config;
        this.reader = new CsvDataReader(this.toBufferedReader(reader), config);
    }

    public BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    public void write(T object) {
        throw new UnsupportedOperationException("unsupported write method.");
    }

    @Override
    public T read() {
        String[] record = this.readLine();
        if (record == null) {
            return null;
        }
        return this.createObject(record);
    }

    protected String[] readHeader() {
        return this.config.isRequiredHeader() ? this.readLine() : null;
    }

    protected abstract T createObject(String[] var1);

    protected String[] readLine() {
        String[] record = this.reader.read();
        while (this.config.isIgnoreEmptyLine() && CsvObjectMapperSupport.isEmptyLine(record)) {
            record = this.reader.read();
        }
        return record;
    }

    @Override
    public void close() {
        FileUtil.closeQuietly((Closeable[])new Closeable[]{this.reader});
    }

    private static boolean isEmptyLine(String[] record) {
        return record != null && record.length == 1 && StringUtil.isNullOrEmpty((String)record[0]);
    }
}

