/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import nablarch.common.databind.DataWriter;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.core.util.StringUtil;

public class CsvDataWriter
implements DataWriter<Object[]> {
    private final CsvDataBindConfig config;
    private final BufferedWriter writer;
    private final String[] properties;

    public CsvDataWriter(BufferedWriter writer, CsvDataBindConfig config, String[] properties) {
        this.config = config;
        this.writer = writer;
        this.properties = properties;
    }

    private static Object nullToEmpty(Object column) {
        return column == null ? "" : column;
    }

    private void writeField(String fieldName, Object fieldValue) throws IOException {
        String fieldStr = StringUtil.toString((Object)fieldValue);
        char quote = this.config.getQuote();
        boolean quotedField = this.isQuotedField(fieldName, fieldValue);
        if (quotedField) {
            this.writer.write(quote);
        }
        for (int i = 0; i < fieldStr.length(); ++i) {
            char c = fieldStr.charAt(i);
            this.writer.write(c);
            if (c != quote) continue;
            this.writer.write(c);
        }
        if (quotedField) {
            this.writer.write(quote);
        }
    }

    private boolean isQuotedField(String fieldName, Object fieldValue) {
        String fieldStr = fieldValue.toString();
        if (this.config.getQuoteMode() == CsvDataBindConfig.QuoteMode.ALL) {
            return true;
        }
        if (this.config.getQuoteMode() == CsvDataBindConfig.QuoteMode.NOT_NUMERIC) {
            return !Number.class.isInstance(fieldValue);
        }
        if (this.config.getQuoteMode() == CsvDataBindConfig.QuoteMode.CUSTOM) {
            return this.config.getQuotedColumnNames().contains(fieldName);
        }
        if (this.config.getQuoteMode() == CsvDataBindConfig.QuoteMode.NORMAL) {
            return this.hasEscapedChar(fieldStr);
        }
        return false;
    }

    private boolean hasEscapedChar(String value) {
        for (char c : value.toCharArray()) {
            if (c != '\r' && c != '\n' && c != this.config.getQuote() && c != this.config.getFieldSeparator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(Object[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("columns should not be empty and null.");
        }
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                this.writer.write(this.config.getFieldSeparator());
            }
            Object column = data[i];
            this.writeField(this.properties[i], CsvDataWriter.nullToEmpty(column));
        }
        this.writer.write(this.config.getLineSeparator());
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

