/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nablarch.common.databind.DataReader;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvTokenizer;

public class CsvDataReader
implements DataReader<String[]> {
    private final CsvTokenizer tokenizer;
    private final BufferedReader reader;

    public CsvDataReader(BufferedReader bufferedReader) {
        this(bufferedReader, CsvDataBindConfig.DEFAULT);
    }

    public CsvDataReader(BufferedReader bufferedReader, CsvDataBindConfig format) {
        this.reader = bufferedReader;
        this.tokenizer = new CsvTokenizer(bufferedReader, format);
    }

    @Override
    public String[] read() {
        try {
            if (this.tokenizer.isEndOfFile()) {
                return null;
            }
            List<String> record = this.readLine();
            return record.toArray(new String[record.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read file.", e);
        }
    }

    private List<String> readLine() throws IOException {
        ArrayList<String> record = new ArrayList<String>();
        this.tokenizer.reset();
        while (!this.tokenizer.isEndOfLine()) {
            record.add(this.tokenizer.next());
        }
        return record;
    }

    public long getLineNumber() {
        return this.tokenizer.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

