/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.DataBindConfigConverter;
import nablarch.common.databind.csv.Csv;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvFormat;
import nablarch.common.databind.csv.Quoted;
import nablarch.core.beans.BeanUtil;

public class CsvDataBindConfigConverter
implements DataBindConfigConverter<Csv> {
    @Override
    public DataBindConfig convert(Class<?> beanClass) {
        Csv csv = beanClass.getAnnotation(Csv.class);
        CsvDataBindConfigConverter.verifyCsvConfig(beanClass, csv);
        CsvFormat csvFormat = beanClass.getAnnotation(CsvFormat.class);
        CsvDataBindConfigConverter.verifyCsvFormat(beanClass, csv, csvFormat);
        CsvDataBindConfig config = csvFormat == null ? ((CsvDataBindConfig)csv.type().getConfig()).withProperties(csv.properties()) : CsvDataBindConfig.DEFAULT.withFieldSeparator(csvFormat.fieldSeparator()).withLineSeparator(csvFormat.lineSeparator()).withQuote(csvFormat.quote()).withIgnoreEmptyLine(csvFormat.ignoreEmptyLine()).withRequiredHeader(csvFormat.requiredHeader()).withProperties(csv.properties()).withCharset(csvFormat.charset()).withEmptyToNull(csvFormat.emptyToNull()).withQuoteMode(csvFormat.quoteMode());
        if (config.getQuoteMode() == CsvDataBindConfig.QuoteMode.CUSTOM) {
            config = config.withQuotedColumnNames(CsvDataBindConfigConverter.findQuotedItemList(beanClass));
        }
        if (config.isRequiredHeader()) {
            if (csv.headers().length == csv.properties().length) {
                config = config.withHeaderTitles(csv.headers());
            } else {
                throw new IllegalStateException(MessageFormat.format("headers and properties size does not match. class = [{0}]", beanClass.getName()));
            }
        }
        return config;
    }

    @Override
    public Class<Csv> getType() {
        return Csv.class;
    }

    private static <T> void verifyCsvFormat(Class<T> clazz, Csv csv, CsvFormat csvFormat) {
        if (csv.type() != Csv.CsvType.CUSTOM && csvFormat != null) {
            throw new IllegalStateException(MessageFormat.format("CsvFormat annotation can not defined because CsvType is not CUSTOM. class = [{0}]", clazz.getName()));
        }
    }

    private static <T> void verifyCsvConfig(Class<T> clazz, Csv csv) {
        if (csv.properties().length == 0) {
            throw new IllegalStateException(MessageFormat.format("properties is required. class = [{0}]", clazz.getName()));
        }
    }

    private static <T> String[] findQuotedItemList(Class<T> clazz) {
        PropertyDescriptor[] pds;
        ArrayList<String> quotedColumnNames = new ArrayList<String>();
        for (PropertyDescriptor pd : pds = BeanUtil.getPropertyDescriptors(clazz)) {
            if (pd.getReadMethod().getAnnotation(Quoted.class) == null) continue;
            quotedColumnNames.add(pd.getName());
        }
        return quotedColumnNames.toArray(new String[quotedColumnNames.size()]);
    }
}

