/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import nablarch.common.databind.DataBindConfig;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@Published
public class CsvDataBindConfig
implements DataBindConfig {
    private static final Pattern VALID_LINE_SEPARATOR = Pattern.compile("(\r\n|\n|\r)");
    private final char fieldSeparator;
    private final String lineSeparator;
    private final char quote;
    private final boolean ignoreEmptyLine;
    private final boolean requiredHeader;
    private final Charset charset;
    private final QuoteMode quoteMode;
    private final boolean emptyToNull;
    private final List<String> quotedColumnNames;
    private final String[] headerTitles;
    private final String[] properties;
    public static final CsvDataBindConfig DEFAULT = new CsvDataBindConfig(',', "\r\n", '\"', true, true, new String[0], new String[0], Charset.forName("UTF-8"), true, QuoteMode.NORMAL, Collections.<String>emptyList());
    public static final CsvDataBindConfig RFC4180 = DEFAULT.withIgnoreEmptyLine(false).withRequiredHeader(false);
    public static final CsvDataBindConfig EXCEL = DEFAULT.withIgnoreEmptyLine(false).withRequiredHeader(false);
    public static final CsvDataBindConfig TSV = DEFAULT.withFieldSeparator('\t').withRequiredHeader(false).withIgnoreEmptyLine(false);

    public CsvDataBindConfig(char fieldSeparator, String lineSeparator, char quote, boolean ignoreEmptyLine, boolean requiredHeader, String[] headerTitles, Charset charset, boolean emptyToNull, QuoteMode quoteMode, List<String> quotedColumnNames) {
        if (!VALID_LINE_SEPARATOR.matcher(lineSeparator).matches()) {
            throw new IllegalArgumentException("invalid line separator. must be set '\\r\\n or \\n or \\r'");
        }
        this.fieldSeparator = fieldSeparator;
        this.lineSeparator = lineSeparator;
        this.quote = quote;
        this.ignoreEmptyLine = ignoreEmptyLine;
        this.requiredHeader = requiredHeader;
        this.charset = charset;
        this.emptyToNull = emptyToNull;
        this.headerTitles = headerTitles;
        this.properties = new String[0];
        this.quoteMode = quoteMode;
        this.quotedColumnNames = quotedColumnNames;
    }

    public CsvDataBindConfig(char fieldSeparator, String lineSeparator, char quote, boolean ignoreEmptyLine, boolean requiredHeader, String[] headerTitles, String[] properties, Charset charset, boolean emptyToNull, QuoteMode quoteMode, List<String> quotedColumnNames) {
        if (!VALID_LINE_SEPARATOR.matcher(lineSeparator).matches()) {
            throw new IllegalArgumentException("invalid line separator. must be set '\\r\\n or \\n or \\r'");
        }
        this.fieldSeparator = fieldSeparator;
        this.lineSeparator = lineSeparator;
        this.quote = quote;
        this.ignoreEmptyLine = ignoreEmptyLine;
        this.requiredHeader = requiredHeader;
        this.charset = charset;
        this.emptyToNull = emptyToNull;
        this.headerTitles = headerTitles;
        this.properties = properties;
        this.quoteMode = quoteMode;
        this.quotedColumnNames = quotedColumnNames;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public CsvDataBindConfig withFieldSeparator(char newFieldSeparator) {
        return new CsvDataBindConfig(newFieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public CsvDataBindConfig withLineSeparator(String newLineSeparator) {
        return new CsvDataBindConfig(this.fieldSeparator, newLineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public char getQuote() {
        return this.quote;
    }

    public CsvDataBindConfig withQuote(char newQuote) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, newQuote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public boolean isIgnoreEmptyLine() {
        return this.ignoreEmptyLine;
    }

    public CsvDataBindConfig withIgnoreEmptyLine() {
        return this.withIgnoreEmptyLine(true);
    }

    public CsvDataBindConfig withIgnoreEmptyLine(boolean newOption) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, newOption, this.requiredHeader, this.headerTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public boolean isRequiredHeader() {
        return this.requiredHeader;
    }

    public CsvDataBindConfig withRequiredHeader() {
        return this.withRequiredHeader(true);
    }

    public CsvDataBindConfig withRequiredHeader(boolean newOption) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, newOption, this.headerTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public String[] getHeaderTitles() {
        return this.headerTitles;
    }

    public CsvDataBindConfig withHeaderTitles(String ... newHeaderTitles) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, newHeaderTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public String[] getProperties() {
        return this.properties;
    }

    public CsvDataBindConfig withProperties(String ... newProperties) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, newProperties, this.charset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public String[] getKeys() {
        return StringUtil.hasValue((String[])this.properties) ? this.properties : this.headerTitles;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public CsvDataBindConfig withCharset(String newCharset) {
        return this.withCharset(Charset.forName(newCharset));
    }

    public CsvDataBindConfig withCharset(Charset newCharset) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, newCharset, this.emptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public boolean isEmptyToNull() {
        return this.emptyToNull;
    }

    public CsvDataBindConfig withEmptyToNull(boolean newEmptyToNull) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, this.charset, newEmptyToNull, this.quoteMode, this.quotedColumnNames);
    }

    public QuoteMode getQuoteMode() {
        return this.quoteMode;
    }

    public CsvDataBindConfig withQuoteMode(QuoteMode newQuoteMode) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, this.charset, this.emptyToNull, newQuoteMode, this.quotedColumnNames);
    }

    public List<String> getQuotedColumnNames() {
        return Collections.unmodifiableList(this.quotedColumnNames);
    }

    public CsvDataBindConfig withQuotedColumnNames(String ... fieldNames) {
        return new CsvDataBindConfig(this.fieldSeparator, this.lineSeparator, this.quote, this.ignoreEmptyLine, this.requiredHeader, this.headerTitles, this.properties, this.charset, this.emptyToNull, this.quoteMode, Arrays.asList(fieldNames));
    }

    public void verify() {
        if (this.requiredHeader && StringUtil.isNullOrEmpty((String[])this.headerTitles)) {
            throw new IllegalArgumentException("csv header is required.");
        }
        if (!this.requiredHeader && StringUtil.isNullOrEmpty((String[])this.properties)) {
            throw new IllegalArgumentException("csv header or property is required.");
        }
        if (this.requiredHeader && StringUtil.hasValue((String[])this.properties) && this.headerTitles.length != this.properties.length) {
            throw new IllegalArgumentException("csv header size and property size does not match.");
        }
    }

    @Published
    public static enum QuoteMode {
        NORMAL,
        ALL,
        NOT_NUMERIC,
        CUSTOM;

    }
}

