/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import nablarch.common.databind.DataBindUtil;
import nablarch.common.databind.InvalidDataFormatException;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvObjectMapperSupport;
import nablarch.core.util.StringUtil;

public class CsvBeanMapper<T>
extends CsvObjectMapperSupport<T> {
    private final Class<T> clazz;
    private final String lineNumberPropertyName;

    public CsvBeanMapper(Class<T> clazz, CsvDataBindConfig config, InputStream inputStream) {
        this(clazz, config, new InputStreamReader(inputStream, config.getCharset()));
    }

    public CsvBeanMapper(Class<T> clazz, CsvDataBindConfig config, Reader reader) {
        super(config, reader);
        this.clazz = clazz;
        this.lineNumberPropertyName = DataBindUtil.findLineNumberProperty(clazz);
        this.readHeader();
    }

    @Override
    protected T createObject(String[] record) {
        String[] keys = this.config.getKeys();
        if (keys.length != record.length) {
            throw new InvalidDataFormatException("property size does not match. expected field count = [" + keys.length + "]," + " actual field count = [" + record.length + "].", this.reader.getLineNumber());
        }
        if (StringUtil.isNullOrEmpty((String)this.lineNumberPropertyName)) {
            return DataBindUtil.getInstance(this.clazz, keys, record);
        }
        return DataBindUtil.getInstanceWithLineNumber(this.clazz, keys, record, this.lineNumberPropertyName, this.reader.getLineNumber());
    }
}

