/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.core.util.annotation.Published;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Published
public @interface Csv {
    public CsvType type();

    public String[] properties();

    public String[] headers() default {};

    public static enum CsvType {
        DEFAULT{

            @Override
            public DataBindConfig getConfig() {
                return CsvDataBindConfig.DEFAULT;
            }
        }
        ,
        RFC4180{

            @Override
            public DataBindConfig getConfig() {
                return CsvDataBindConfig.RFC4180;
            }
        }
        ,
        EXCEL{

            @Override
            public DataBindConfig getConfig() {
                return CsvDataBindConfig.EXCEL;
            }
        }
        ,
        TSV{

            @Override
            public DataBindConfig getConfig() {
                return CsvDataBindConfig.TSV;
            }
        }
        ,
        CUSTOM{

            @Override
            public DataBindConfig getConfig() {
                return null;
            }
        };


        public abstract DataBindConfig getConfig();
    }
}

