/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import nablarch.common.databind.BasicObjectMapperFactory;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.ObjectMapper;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public abstract class ObjectMapperFactory {
    private static final ObjectMapperFactory FACTORY = new BasicObjectMapperFactory();

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, InputStream stream) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, stream);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, InputStream stream, DataBindConfig dataBindConfig) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, stream, dataBindConfig);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, Reader reader) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, reader);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, Reader reader, DataBindConfig dataBindConfig) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, reader, dataBindConfig);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, String input) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, new StringReader(input));
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, String input, DataBindConfig dataBindConfig) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, new StringReader(input), dataBindConfig);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, OutputStream stream) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, stream);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, OutputStream stream, DataBindConfig dataBindConfig) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, stream, dataBindConfig);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, Writer writer) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, writer);
    }

    @Published
    public static <T> ObjectMapper<T> create(Class<T> clazz, Writer writer, DataBindConfig dataBindConfig) {
        ObjectMapperFactory factory = ObjectMapperFactory.createFactory();
        return factory.createMapper(clazz, writer, dataBindConfig);
    }

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, InputStream var2);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, InputStream var2, DataBindConfig var3);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, Reader var2);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, Reader var2, DataBindConfig var3);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, OutputStream var2);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, OutputStream var2, DataBindConfig var3);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, Writer var2);

    public abstract <T> ObjectMapper<T> createMapper(Class<T> var1, Writer var2, DataBindConfig var3);

    private static ObjectMapperFactory createFactory() {
        ObjectMapperFactory factory = (ObjectMapperFactory)SystemRepository.get((String)"objectMapperFactory");
        return factory == null ? FACTORY : factory;
    }
}

