/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.ObjectMapper;
import nablarch.common.databind.csv.BeanCsvMapper;
import nablarch.common.databind.csv.CsvBeanMapper;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvMapMapper;
import nablarch.common.databind.csv.MapCsvMapper;
import nablarch.common.databind.fixedlength.BeanFixedLengthMapper;
import nablarch.common.databind.fixedlength.FixedLengthBeanMapper;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.FixedLengthMapMapper;
import nablarch.common.databind.fixedlength.MapFixedLengthMapper;

enum MapperType {
    CSV_BEAN{

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, InputStream stream) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            return new CsvBeanMapper<T>(clazz, csvDataBindConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Reader reader) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            return new CsvBeanMapper<T>(clazz, csvDataBindConfig, reader);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, OutputStream stream) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            return new BeanCsvMapper<T>(clazz, csvDataBindConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Writer writer) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            return new BeanCsvMapper<T>(clazz, csvDataBindConfig, writer);
        }
    }
    ,
    CSV_MAP{

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, InputStream stream) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            csvDataBindConfig.verify();
            return new CsvMapMapper(csvDataBindConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Reader reader) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            csvDataBindConfig.verify();
            return new CsvMapMapper(csvDataBindConfig, reader);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, OutputStream stream) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            csvDataBindConfig.verify();
            return new MapCsvMapper(csvDataBindConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Writer writer) {
            CsvDataBindConfig csvDataBindConfig = (CsvDataBindConfig)CsvDataBindConfig.class.cast(config);
            csvDataBindConfig.verify();
            return new MapCsvMapper(csvDataBindConfig, writer);
        }
    }
    ,
    FIXED_LENGTH_BEAN{

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, InputStream stream) {
            FixedLengthDataBindConfig fixedLengthConfig = (FixedLengthDataBindConfig)FixedLengthDataBindConfig.class.cast(config);
            return new FixedLengthBeanMapper<T>(clazz, fixedLengthConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Reader reader) {
            throw new UnsupportedOperationException("fixed length type does not support reader.");
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, OutputStream stream) {
            FixedLengthDataBindConfig fixedLengthConfig = (FixedLengthDataBindConfig)FixedLengthDataBindConfig.class.cast(config);
            return new BeanFixedLengthMapper<T>(clazz, fixedLengthConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Writer writer) {
            throw new UnsupportedOperationException("fixed length type does not support writer.");
        }
    }
    ,
    FIXED_LENGTH_MAP{

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, InputStream stream) {
            FixedLengthDataBindConfig fixedLengthConfig = (FixedLengthDataBindConfig)FixedLengthDataBindConfig.class.cast(config);
            return new FixedLengthMapMapper(fixedLengthConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Reader reader) {
            throw new UnsupportedOperationException("fixed length type does not support reader.");
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, OutputStream stream) {
            FixedLengthDataBindConfig fixedLengthConfig = (FixedLengthDataBindConfig)FixedLengthDataBindConfig.class.cast(config);
            return new MapFixedLengthMapper(fixedLengthConfig, stream);
        }

        @Override
        <T> ObjectMapper<T> createMapper(Class<T> clazz, DataBindConfig config, Writer writer) {
            throw new UnsupportedOperationException("fixed length type does not support writer.");
        }
    };


    abstract <T> ObjectMapper<T> createMapper(Class<T> var1, DataBindConfig var2, InputStream var3);

    abstract <T> ObjectMapper<T> createMapper(Class<T> var1, DataBindConfig var2, Reader var3);

    abstract <T> ObjectMapper<T> createMapper(Class<T> var1, DataBindConfig var2, OutputStream var3);

    abstract <T> ObjectMapper<T> createMapper(Class<T> var1, DataBindConfig var2, Writer var3);
}

