/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.DataBindUtil;
import nablarch.common.databind.MapperType;
import nablarch.common.databind.ObjectMapper;
import nablarch.common.databind.ObjectMapperFactory;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;

public class BasicObjectMapperFactory
extends ObjectMapperFactory {
    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, InputStream stream) {
        DataBindConfig dataBindConfig = DataBindUtil.createDataBindConfig(clazz);
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            return type.createMapper(clazz, dataBindConfig, stream);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, InputStream stream, DataBindConfig dataBindConfig) {
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            throw new IllegalArgumentException("this class should not be set config. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + ']');
        }
        if (type == MapperType.CSV_MAP || type == MapperType.FIXED_LENGTH_MAP) {
            return type.createMapper(clazz, dataBindConfig, stream);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, Reader reader) {
        DataBindConfig dataBindConfig = DataBindUtil.createDataBindConfig(clazz);
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            return type.createMapper(clazz, dataBindConfig, reader);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, Reader reader, DataBindConfig dataBindConfig) {
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            throw new IllegalArgumentException("this class should not be set config. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + ']');
        }
        if (type == MapperType.CSV_MAP || type == MapperType.FIXED_LENGTH_MAP) {
            return type.createMapper(clazz, dataBindConfig, reader);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, OutputStream stream) {
        DataBindConfig dataBindConfig = DataBindUtil.createDataBindConfig(clazz);
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            return type.createMapper(clazz, dataBindConfig, stream);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, OutputStream stream, DataBindConfig dataBindConfig) {
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            throw new IllegalArgumentException("this class should not be set config. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + ']');
        }
        if (type == MapperType.CSV_MAP || type == MapperType.FIXED_LENGTH_MAP) {
            return type.createMapper(clazz, dataBindConfig, stream);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, Writer writer) {
        DataBindConfig dataBindConfig = DataBindUtil.createDataBindConfig(clazz);
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            return type.createMapper(clazz, dataBindConfig, writer);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    @Override
    public <T> ObjectMapper<T> createMapper(Class<T> clazz, Writer writer, DataBindConfig dataBindConfig) {
        MapperType type = this.toMapperType(clazz, dataBindConfig);
        if (type == MapperType.CSV_BEAN || type == MapperType.FIXED_LENGTH_BEAN) {
            throw new IllegalArgumentException("this class should not be set config. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + ']');
        }
        if (type == MapperType.CSV_MAP || type == MapperType.FIXED_LENGTH_MAP) {
            return type.createMapper(clazz, dataBindConfig, writer);
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    protected MapperType toMapperType(Class<?> clazz, DataBindConfig dataBindConfig) {
        if (Map.class.isAssignableFrom(clazz) && dataBindConfig instanceof CsvDataBindConfig) {
            return MapperType.CSV_MAP;
        }
        if (dataBindConfig instanceof CsvDataBindConfig) {
            return MapperType.CSV_BEAN;
        }
        if (Map.class.isAssignableFrom(clazz) && dataBindConfig instanceof FixedLengthDataBindConfig) {
            return MapperType.FIXED_LENGTH_MAP;
        }
        if (dataBindConfig instanceof FixedLengthDataBindConfig) {
            return MapperType.FIXED_LENGTH_BEAN;
        }
        throw new IllegalArgumentException("Unsupported config or class. class = [" + BasicObjectMapperFactory.toFQCN(clazz) + "]," + " config = [" + BasicObjectMapperFactory.toFQCN(dataBindConfig) + ']');
    }

    private static String toFQCN(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return object.getClass().getName();
    }
}

