/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.search.Bound;
import com.metamx.collections.spatial.search.RadiusBound;
import com.metamx.collections.spatial.search.RectangularBound;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class ImmutableRTreeTest {
    @Test
    public void testToAndFromByteBuffer() {
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 1.0f}, 2);
        tree.insert(new float[]{2.0f, 2.0f}, 3);
        tree.insert(new float[]{3.0f, 3.0f}, 4);
        tree.insert(new float[]{4.0f, 4.0f}, 5);
        ImmutableRTree firstTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        ByteBuffer buffer = ByteBuffer.wrap(firstTree.toBytes());
        ImmutableRTree secondTree = new ImmutableRTree(buffer);
        Iterable points = secondTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 10.0f));
        ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
        Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntSet.IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchNoSplit() {
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{10.0f, 10.0f}, 10);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{27.0f, 34.0f}, 20);
        tree.insert(new float[]{106.0f, 19.0f}, 30);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{4.0f, 72.0f}, 40);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        tree.insert(new float[]{119.0f, -78.0f}, 50);
        Assert.assertEquals((int)tree.getRoot().getChildren().size(), (int)10);
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
        Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntSet.IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit() {
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        Random rand = new Random();
        for (int i = 0; i < 95; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
        Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntSet.IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit2() {
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
        tree.insert(new float[]{0.0f, 0.0f}, 0);
        tree.insert(new float[]{1.0f, 3.0f}, 1);
        tree.insert(new float[]{4.0f, 2.0f}, 2);
        tree.insert(new float[]{7.0f, 3.0f}, 3);
        tree.insert(new float[]{8.0f, 6.0f}, 4);
        Random rand = new Random();
        for (int i = 5; i < 5000; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}));
        ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
        Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3, 4});
        IntSet.IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplit3() {
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
        tree.insert(new float[]{0.0f, 0.0f}, 0);
        tree.insert(new float[]{1.0f, 3.0f}, 1);
        tree.insert(new float[]{4.0f, 2.0f}, 2);
        tree.insert(new float[]{7.0f, 3.0f}, 3);
        tree.insert(new float[]{8.0f, 6.0f}, 4);
        Random rand = new Random();
        for (int i = 5; i < 5000; ++i) {
            tree.insert(new float[]{(float)((double)(rand.nextFloat() * 10.0f) + 10.0), (float)((double)(rand.nextFloat() * 10.0f) + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f));
        ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
        Assert.assertTrue((finalSet.size() >= 3 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{0, 1, 2});
        IntSet.IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    @Test
    public void testSearchWithSplitLimitedBound() {
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
        tree.insert(new float[]{0.0f, 0.0f}, 1);
        tree.insert(new float[]{1.0f, 3.0f}, 2);
        tree.insert(new float[]{4.0f, 2.0f}, 3);
        tree.insert(new float[]{5.0f, 0.0f}, 4);
        tree.insert(new float[]{-4.0f, -3.0f}, 5);
        Random rand = new Random();
        for (int i = 0; i < 4995; ++i) {
            tree.insert(new float[]{(float)(rand.nextDouble() * 10.0 + 10.0), (float)(rand.nextDouble() * 10.0 + 10.0)}, i);
        }
        ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f, 2));
        ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
        Assert.assertTrue((finalSet.size() >= 5 ? 1 : 0) != 0);
        HashSet expected = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5});
        IntSet.IntIterator iter = finalSet.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(iter.next()));
        }
    }

    public void showBenchmarks() {
        boolean start = true;
        int factor = 10;
        int end = 10000000;
        int radius = 10;
        for (int numPoints = 1; numPoints <= 10000000; numPoints *= 10) {
            try {
                RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
                Stopwatch stopwatch = new Stopwatch().start();
                Random rand = new Random();
                for (int i = 0; i < numPoints; ++i) {
                    tree.insert(new float[]{(float)(rand.nextDouble() * 100.0), (float)(rand.nextDouble() * 100.0)}, i);
                }
                long stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: insert = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
                stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: size = %,d bytes%n", numPoints, searchTree.toBytes().length);
                System.out.printf("[%,d]: buildImmutable = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                Iterable points = searchTree.search((Bound)new RadiusBound(new float[]{50.0f, 50.0f}, 10.0f));
                Iterables.size((Iterable)points);
                stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: search = %,dms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
                stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: union of %,d points in %,d ms%n", numPoints, finalSet.size(), stop);
                continue;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public void showBenchmarksBoundWithLimits() {
        int start = 10000000;
        int factor = 10;
        int end = 10000000;
        for (int numPoints = 10000000; numPoints <= 10000000; numPoints *= 10) {
            try {
                RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50));
                Stopwatch stopwatch = new Stopwatch().start();
                Random rand = new Random();
                for (int i = 0; i < numPoints; ++i) {
                    tree.insert(new float[]{(float)(rand.nextDouble() * 100.0), (float)(rand.nextDouble() * 100.0)}, i);
                }
                long stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: insert = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableRTree searchTree = ImmutableRTree.newImmutableFromMutable((RTree)tree);
                stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: size = %,d bytes%n", numPoints, searchTree.toBytes().length);
                System.out.printf("[%,d]: buildImmutable = %,d ms%n", numPoints, stop);
                stopwatch.reset().start();
                Iterable points = searchTree.search((Bound)new RectangularBound(new float[]{40.0f, 40.0f}, new float[]{60.0f, 60.0f}, 100));
                Iterables.size((Iterable)points);
                stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: search = %,dms%n", numPoints, stop);
                stopwatch.reset().start();
                ImmutableConciseSet finalSet = ImmutableConciseSet.union((Iterable)points);
                stop = stopwatch.elapsedMillis();
                System.out.printf("[%,d]: union of %,d points in %,d ms%n", numPoints, finalSet.size(), stop);
                continue;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

