/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.annotation.MultiRabbitBootstrapConfiguration;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.SimpleRoutingConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryContextWrapper;
import org.springframework.boot.autoconfigure.amqp.MultiRabbitConnectionFactoryWrapper;
import org.springframework.boot.autoconfigure.amqp.MultiRabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitProperties.class, MultiRabbitProperties.class})
@Import(value={MultiRabbitBootstrapConfiguration.class, RabbitAnnotationDrivenConfiguration.class})
public class MultiRabbitAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiRabbitAutoConfiguration.class);

    @Bean(value={"defaultRabbitAdmin"})
    @Primary
    @ConditionalOnSingleCandidate(value=ConnectionFactory.class)
    @ConditionalOnProperty(prefix="spring.rabbitmq", name={"dynamic"}, matchIfMissing=true)
    public AmqpAdmin amqpAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Primary
    @Bean(value={"rabbitConnectionFactoryCreator"})
    public RabbitAutoConfiguration.RabbitConnectionFactoryCreator rabbitConnectionFactoryCreator() {
        return new RabbitAutoConfiguration.RabbitConnectionFactoryCreator();
    }

    @Configuration
    @DependsOn(value={"rabbitConnectionFactoryCreator"})
    protected static class MultiRabbitConnectionFactoryCreator
    implements BeanFactoryAware,
    ApplicationContextAware {
        private ConfigurableListableBeanFactory beanFactory;
        private ApplicationContext applicationContext;
        private final RabbitAutoConfiguration.RabbitConnectionFactoryCreator springFactoryCreator;
        private final ObjectProvider<ConnectionNameStrategy> connectionNameStrategy;

        MultiRabbitConnectionFactoryCreator(RabbitAutoConfiguration.RabbitConnectionFactoryCreator springFactoryCreator, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) {
            this.springFactoryCreator = springFactoryCreator;
            this.connectionNameStrategy = connectionNameStrategy;
        }

        @Bean
        public ConnectionFactoryContextWrapper contextWrapper(ConnectionFactory connectionFactory) {
            return new ConnectionFactoryContextWrapper(connectionFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        public MultiRabbitConnectionFactoryWrapper externalEmptyWrapper() {
            return new MultiRabbitConnectionFactoryWrapper();
        }

        @Primary
        @Bean(value={"multiRabbitConnectionFactory"})
        public ConnectionFactory routingConnectionFactory(RabbitProperties rabbitProperties, MultiRabbitProperties multiRabbitProperties, MultiRabbitConnectionFactoryWrapper externalWrapper) {
            MultiRabbitConnectionFactoryWrapper internalWrapper = this.instantiateConnectionFactories(rabbitProperties, multiRabbitProperties);
            MultiRabbitConnectionFactoryWrapper aggregatedWrapper = this.aggregateConnectionFactoryWrappers(internalWrapper, externalWrapper);
            aggregatedWrapper.getContainerFactories().forEach(this::registerContainerFactoryBean);
            aggregatedWrapper.getRabbitAdmins().forEach(this::registerRabbitAdminBean);
            SimpleRoutingConnectionFactory connectionFactory = new SimpleRoutingConnectionFactory();
            connectionFactory.setTargetConnectionFactories(aggregatedWrapper.getConnectionFactories());
            connectionFactory.setDefaultTargetConnectionFactory(aggregatedWrapper.getDefaultConnectionFactory());
            return connectionFactory;
        }

        private MultiRabbitConnectionFactoryWrapper aggregateConnectionFactoryWrappers(MultiRabbitConnectionFactoryWrapper internalWrapper, MultiRabbitConnectionFactoryWrapper externalWrapper) {
            MultiRabbitConnectionFactoryWrapper aggregatedWrapper = new MultiRabbitConnectionFactoryWrapper();
            this.copyConnectionSets(aggregatedWrapper, internalWrapper);
            this.copyConnectionSets(aggregatedWrapper, externalWrapper);
            aggregatedWrapper.setDefaultConnectionFactory(externalWrapper.getDefaultConnectionFactory() != null ? externalWrapper.getDefaultConnectionFactory() : internalWrapper.getDefaultConnectionFactory());
            return aggregatedWrapper;
        }

        private void copyConnectionSets(MultiRabbitConnectionFactoryWrapper aggregatedWrapper, MultiRabbitConnectionFactoryWrapper sourceWrapper) {
            sourceWrapper.getConnectionFactories().forEach((key, value) -> aggregatedWrapper.addConnectionFactory(String.valueOf(key), sourceWrapper.getConnectionFactories().get(key), sourceWrapper.getContainerFactories().get(key), sourceWrapper.getRabbitAdmins().get(key)));
        }

        private MultiRabbitConnectionFactoryWrapper instantiateConnectionFactories(RabbitProperties rabbitProperties, MultiRabbitProperties multiRabbitProperties) {
            String defaultConnectionFactoryKey;
            MultiRabbitConnectionFactoryWrapper wrapper = new MultiRabbitConnectionFactoryWrapper();
            Map<Object, Object> propertiesMap = multiRabbitProperties != null ? multiRabbitProperties.getConnections() : Collections.emptyMap();
            propertiesMap.forEach((key, value) -> {
                CachingConnectionFactory connectionFactory = this.instantiateConnectionFactory((RabbitProperties)value);
                SimpleRabbitListenerContainerFactory containerFactory = this.newContainerFactory((ConnectionFactory)connectionFactory);
                RabbitAdmin rabbitAdmin = this.newRabbitAdmin((ConnectionFactory)connectionFactory);
                wrapper.addConnectionFactory((String)key, (ConnectionFactory)connectionFactory, (AbstractRabbitListenerContainerFactory)containerFactory, rabbitAdmin);
            });
            String string = defaultConnectionFactoryKey = multiRabbitProperties != null ? multiRabbitProperties.getDefaultConnection() : null;
            if (StringUtils.hasText((String)defaultConnectionFactoryKey) && !multiRabbitProperties.getConnections().containsKey(defaultConnectionFactoryKey)) {
                String msg = String.format("MultiRabbitMQ broker '%s' set as default does not exist in configuration", defaultConnectionFactoryKey);
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
            CachingConnectionFactory defaultConnectionFactory = StringUtils.hasText((String)defaultConnectionFactoryKey) ? wrapper.getConnectionFactories().get(defaultConnectionFactoryKey) : this.instantiateConnectionFactory(rabbitProperties);
            wrapper.setDefaultConnectionFactory((ConnectionFactory)defaultConnectionFactory);
            return wrapper;
        }

        private SimpleRabbitListenerContainerFactory newContainerFactory(ConnectionFactory connectionFactory) {
            SimpleRabbitListenerContainerFactory containerFactory = new SimpleRabbitListenerContainerFactory();
            containerFactory.setConnectionFactory(connectionFactory);
            return containerFactory;
        }

        private RabbitAdmin newRabbitAdmin(ConnectionFactory connectionFactory) {
            RabbitAdmin rabbitAdmin = new RabbitAdmin(connectionFactory);
            rabbitAdmin.setApplicationContext(this.applicationContext);
            rabbitAdmin.afterPropertiesSet();
            return rabbitAdmin;
        }

        private CachingConnectionFactory instantiateConnectionFactory(RabbitProperties rabbitProperties) {
            try {
                return this.springFactoryCreator.rabbitConnectionFactory(rabbitProperties, this.connectionNameStrategy);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void registerContainerFactoryBean(String name, AbstractRabbitListenerContainerFactory containerFactory) {
            this.beanFactory.registerSingleton(name, (Object)containerFactory);
        }

        private void registerRabbitAdminBean(String name, RabbitAdmin rabbitAdmin) {
            rabbitAdmin.setApplicationContext(this.applicationContext);
            rabbitAdmin.afterPropertiesSet();
            this.beanFactory.registerSingleton(name + "-admin", (Object)rabbitAdmin);
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }
    }
}

