/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLSubQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalFunctionCall;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.WithBuilder;
import com.mysema.query.support.DetachableQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.CollectionExpressionBase;
import com.mysema.query.types.expr.CollectionOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@BridgeMethodsAdded
public abstract class DetachableSQLQuery<Q extends DetachableSQLQuery<Q>>
extends DetachableQuery<Q>
implements SQLCommonQuery<Q> {
    protected final Configuration configuration;

    public DetachableSQLQuery() {
        this((QueryMetadata)new DefaultQueryMetadata().noValidate());
    }

    public DetachableSQLQuery(QueryMetadata metadata) {
        this(Configuration.DEFAULT, metadata);
    }

    public DetachableSQLQuery(Configuration configuration, QueryMetadata metadata) {
        super(new QueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.configuration = configuration;
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        Expression flag = TemplateExpressionImpl.create((Class)expr.getType(), (String)(prefix + "{0}"), expr);
        return (Q)((DetachableSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag.Position position, String flag) {
        return (Q)((DetachableSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (Q)((DetachableSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q addJoinFlag(String flag) {
        return (Q)this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q addJoinFlag(String flag, JoinFlag.Position position) {
        this.queryMixin.addJoinFlag(new JoinFlag(flag, position));
        return (Q)this;
    }

    public BooleanExpression exists() {
        return this.unique(NumberTemplate.ONE).exists();
    }

    public BooleanExpression notExists() {
        return this.exists().not();
    }

    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q from(Expression<?> arg) {
        return (Q)((DetachableSQLQuery)this.queryMixin.from(arg));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q from(Expression<?> ... args) {
        return (Q)((DetachableSQLQuery)this.queryMixin.from(args));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.from(ExpressionUtils.as(subQuery, alias)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q fullJoin(EntityPath<?> target) {
        return (Q)((DetachableSQLQuery)this.queryMixin.fullJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q fullJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((DetachableSQLQuery)this.queryMixin.fullJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q fullJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q innerJoin(EntityPath<?> target) {
        return (Q)((DetachableSQLQuery)this.queryMixin.innerJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q innerJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((DetachableSQLQuery)this.queryMixin.innerJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q innerJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q join(EntityPath<?> target) {
        return (Q)((DetachableSQLQuery)this.queryMixin.join(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q join(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.join(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((DetachableSQLQuery)this.queryMixin.join(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q join(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.join(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q leftJoin(EntityPath<?> target) {
        return (Q)((DetachableSQLQuery)this.queryMixin.leftJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q leftJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((DetachableSQLQuery)this.queryMixin.leftJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q leftJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.leftJoin(target, alias));
    }

    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q on(Predicate condition) {
        return (Q)((DetachableSQLQuery)this.queryMixin.on(condition));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q on(Predicate ... conditions) {
        return (Q)((DetachableSQLQuery)this.queryMixin.on(conditions));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q rightJoin(EntityPath<?> target) {
        return (Q)((DetachableSQLQuery)this.queryMixin.rightJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q rightJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public <E> Q rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((DetachableSQLQuery)this.queryMixin.rightJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q rightJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((DetachableSQLQuery)this.queryMixin.rightJoin(target, alias));
    }

    private <T> CollectionExpressionBase<?, T> union(Operator<Object> op, List<? extends SubQueryExpression<?>> sq) {
        Expression rv = (Expression)sq.get(0);
        if (sq.size() == 1 && !CollectionExpression.class.isInstance(rv)) {
            return new ListSubQuery(rv.getType(), sq.get(0).getMetadata());
        }
        Class elementType = sq.get(0).getType();
        if (rv instanceof CollectionExpression) {
            elementType = ((CollectionExpression)rv).getParameter(0);
        }
        for (int i = 1; i < sq.size(); ++i) {
            rv = CollectionOperation.create(op, (Class)elementType, (Expression)rv, (Expression)((Expression)sq.get(i)));
        }
        return (CollectionExpressionBase)rv;
    }

    public <T> CollectionExpressionBase<?, T> union(List<? extends SubQueryExpression<T>> sq) {
        return this.union(SQLOps.UNION, sq);
    }

    public <T> CollectionExpressionBase<?, T> union(ListSubQuery<T> ... sq) {
        return this.union(SQLOps.UNION, Arrays.asList(sq));
    }

    public <T> CollectionExpressionBase<?, T> union(SubQueryExpression<T> ... sq) {
        return this.union(SQLOps.UNION, Arrays.asList(sq));
    }

    public <T> CollectionExpressionBase<?, T> unionAll(List<? extends SubQueryExpression<T>> sq) {
        return this.union(SQLOps.UNION_ALL, sq);
    }

    public <T> CollectionExpressionBase<?, T> unionAll(ListSubQuery<T> ... sq) {
        return this.union(SQLOps.UNION_ALL, Arrays.asList(sq));
    }

    public <T> CollectionExpressionBase<?, T> unionAll(SubQueryExpression<T> ... sq) {
        return this.union(SQLOps.UNION_ALL, Arrays.asList(sq));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q withRecursive(Path<?> alias, SubQueryExpression<?> query) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return (Q)this.with((Path)alias, (SubQueryExpression)query);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q withRecursive(Path<?> alias, Expression<?> query) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return (Q)this.with((Path)alias, (Expression)query);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public WithBuilder<Q> withRecursive(Path<?> alias, Path<?> ... columns) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return this.with(alias, columns);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q with(Path<?> alias, SubQueryExpression<?> target) {
        Operation expr = OperationImpl.create((Class)alias.getType(), SQLOps.WITH_ALIAS, alias, target);
        return (Q)((DetachableSQLQuery)this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, (Expression)expr)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLSubQuery.class}, castRequired=true)
    public Q with(Path<?> alias, Expression<?> query) {
        Operation expr = OperationImpl.create((Class)alias.getType(), SQLOps.WITH_ALIAS, alias, query);
        return (Q)((DetachableSQLQuery)this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, (Expression)expr)));
    }

    @Override
    public WithBuilder<Q> with(Path<?> alias, Path<?> ... columns) {
        Expression columnsCombined = ExpressionUtils.list(Object.class, columns);
        SimpleExpression aliasCombined = Expressions.operation((Class)alias.getType(), SQLOps.WITH_COLUMNS, (Expression[])new Expression[]{alias, columnsCombined});
        return new WithBuilder(this.queryMixin, (Expression<?>)aliasCombined);
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    public abstract Q clone();

    protected abstract SQLSerializer createSerializer();

    protected SQLSerializer serialize(boolean forCountRow) {
        SQLSerializer serializer = this.createSerializer();
        serializer.setStrict(false);
        serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        return serializer;
    }

    public SQLBindings getSQL(Expression<?> ... exprs) {
        this.queryMixin.addProjection(exprs);
        SQLSerializer serializer = this.serialize(false);
        ImmutableList.Builder args = ImmutableList.builder();
        Map params = this.getMetadata().getParams();
        for (Object o : serializer.getConstants()) {
            if (o instanceof ParamExpression) {
                if (!params.containsKey(o)) {
                    throw new ParamNotSetException((ParamExpression)o);
                }
                o = this.queryMixin.getMetadata().getParams().get(o);
            }
            args.add(o);
        }
        return new SQLBindings(serializer.toString(), (ImmutableList<Object>)args.build());
    }

    public String toString() {
        if (!this.getMetadata().getJoins().isEmpty()) {
            SQLSerializer serializer = this.serialize(false);
            return serializer.toString().trim();
        }
        return super.toString();
    }
}

