/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Projectable;
import com.mysema.query.Query;
import com.mysema.query.sql.Union;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import java.util.List;

public class UnionImpl<Q extends Query & Projectable, RT>
implements Union<RT> {
    private final Q query;
    private final Expression<?>[] projection;

    public UnionImpl(Q query, List<? extends Expression<?>> projection) {
        this.query = query;
        this.projection = projection.toArray(new Expression[projection.size()]);
    }

    @Override
    public List<RT> list() {
        if (this.projection.length == 1) {
            return ((Projectable)this.query).list(this.projection[0]);
        }
        return ((Projectable)this.query).list(this.projection);
    }

    @Override
    public CloseableIterator<RT> iterate() {
        if (this.projection.length == 1) {
            return ((Projectable)this.query).iterate(this.projection[0]);
        }
        return ((Projectable)this.query).iterate(this.projection);
    }

    @Override
    public Union<RT> orderBy(OrderSpecifier<?> ... o) {
        this.query.orderBy(o);
        return this;
    }

    public String toString() {
        return this.query.toString();
    }
}

