/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.primitives.Primitives;
import com.mysema.commons.lang.Pair;
import com.mysema.query.sql.types.BigDecimalType;
import com.mysema.query.sql.types.BlobType;
import com.mysema.query.sql.types.BooleanType;
import com.mysema.query.sql.types.ByteType;
import com.mysema.query.sql.types.BytesType;
import com.mysema.query.sql.types.CharacterType;
import com.mysema.query.sql.types.ClobType;
import com.mysema.query.sql.types.DateType;
import com.mysema.query.sql.types.DoubleType;
import com.mysema.query.sql.types.FloatType;
import com.mysema.query.sql.types.IntegerType;
import com.mysema.query.sql.types.LongType;
import com.mysema.query.sql.types.NullType;
import com.mysema.query.sql.types.ObjectType;
import com.mysema.query.sql.types.ShortType;
import com.mysema.query.sql.types.StringType;
import com.mysema.query.sql.types.TimeType;
import com.mysema.query.sql.types.TimestampType;
import com.mysema.query.sql.types.Type;
import com.mysema.query.sql.types.URLType;
import com.mysema.query.sql.types.UtilDateType;
import com.mysema.util.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class JavaTypeMapping {
    private static final Map<Class<?>, Type<?>> defaultTypes = new HashMap();
    private final Map<Class<?>, Type<?>> typeByClass = new HashMap();
    private final Map<Class<?>, Type<?>> resolvedTypesByClass = new HashMap();
    private final Map<Pair<String, String>, Type<?>> typeByColumn = new HashMap();

    private static void registerDefault(Type<?> type) {
        defaultTypes.put(type.getReturnedClass(), type);
        Class primitive = Primitives.unwrap(type.getReturnedClass());
        if (primitive != null) {
            defaultTypes.put(primitive, type);
        }
    }

    @Nullable
    public Type<?> getType(String table, String column) {
        return this.typeByColumn.get(Pair.of((Object)table.toLowerCase(), (Object)column.toLowerCase()));
    }

    public <T> Type<T> getType(Class<T> clazz) {
        Type<?> resolvedType = this.resolvedTypesByClass.get(clazz);
        if (resolvedType == null && (resolvedType = this.findType(clazz)) != null) {
            this.resolvedTypesByClass.put(clazz, resolvedType);
        }
        if (resolvedType == null) {
            throw new IllegalArgumentException("Got not user type for " + clazz.getName());
        }
        return resolvedType;
    }

    @Nullable
    private Type<?> findType(Class<?> clazz) {
        Class<?> cl = clazz;
        do {
            if (this.typeByClass.containsKey(cl)) {
                return this.typeByClass.get(cl);
            }
            if (!defaultTypes.containsKey(cl)) continue;
            return defaultTypes.get(cl);
        } while (!(cl = cl.getSuperclass()).equals(Object.class));
        Set interfaces = ReflectionUtils.getImplementedInterfaces(clazz);
        for (Class itf : interfaces) {
            if (this.typeByClass.containsKey(itf)) {
                return this.typeByClass.get(itf);
            }
            if (!defaultTypes.containsKey(itf)) continue;
            return defaultTypes.get(itf);
        }
        return null;
    }

    public void register(Type<?> type) {
        this.typeByClass.put(type.getReturnedClass(), type);
        Class primitive = Primitives.unwrap(type.getReturnedClass());
        if (primitive != null) {
            this.typeByClass.put(primitive, type);
        }
        this.resolvedTypesByClass.clear();
    }

    public void setType(String table, String column, Type<?> type) {
        this.typeByColumn.put((Pair<String, String>)Pair.of((Object)table.toLowerCase(), (Object)column.toLowerCase()), type);
    }

    static {
        JavaTypeMapping.registerDefault(new BigDecimalType());
        JavaTypeMapping.registerDefault(new BlobType());
        JavaTypeMapping.registerDefault(new BooleanType());
        JavaTypeMapping.registerDefault(new BytesType());
        JavaTypeMapping.registerDefault(new ByteType());
        JavaTypeMapping.registerDefault(new CharacterType());
        JavaTypeMapping.registerDefault(new ClobType());
        JavaTypeMapping.registerDefault(new DateType());
        JavaTypeMapping.registerDefault(new DoubleType());
        JavaTypeMapping.registerDefault(new FloatType());
        JavaTypeMapping.registerDefault(new IntegerType());
        JavaTypeMapping.registerDefault(new LongType());
        JavaTypeMapping.registerDefault(new ObjectType());
        JavaTypeMapping.registerDefault(new ShortType());
        JavaTypeMapping.registerDefault(new StringType());
        JavaTypeMapping.registerDefault(new TimestampType());
        JavaTypeMapping.registerDefault(new TimeType());
        JavaTypeMapping.registerDefault(new URLType());
        JavaTypeMapping.registerDefault(new UtilDateType());
        JavaTypeMapping.registerDefault(new NullType());
        try {
            Class.forName("org.joda.time.DateTime");
            JavaTypeMapping.registerDefault((Type)Class.forName("com.mysema.query.sql.types.DateTimeType").newInstance());
            JavaTypeMapping.registerDefault((Type)Class.forName("com.mysema.query.sql.types.LocalDateTimeType").newInstance());
            JavaTypeMapping.registerDefault((Type)Class.forName("com.mysema.query.sql.types.LocalDateType").newInstance());
            JavaTypeMapping.registerDefault((Type)Class.forName("com.mysema.query.sql.types.LocalTimeType").newInstance());
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

