/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.SerializationContext;
import com.mysema.query.types.Ops;

public class CUBRIDTemplates
extends SQLTemplates {
    private final String limitTemplate = "\nlimit {0}";
    private final String offsetLimitTemplate = "\nlimit {0}, {1}";

    public CUBRIDTemplates() {
        this('\\', false);
    }

    public CUBRIDTemplates(boolean quote) {
        this('\\', quote);
    }

    public CUBRIDTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setDummyTable(null);
        this.setParameterMetadataAvailable(false);
        this.add(Ops.MathOps.LN, "ln({0})");
        this.add(Ops.MathOps.LOG, "(ln({0}) / ln({1}))");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SerializationContext context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.getLimit() != null) {
            if (mod.getOffset() != null) {
                context.handle("\nlimit {0}, {1}", mod.getOffset(), mod.getLimit());
            } else {
                context.handle("\nlimit {0}", mod.getLimit());
            }
        }
    }
}

