/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.Assert;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalFunctionCall;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQueryMixin;
import com.mysema.query.sql.SQLResultIterator;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import com.mysema.util.ResultSetAdapter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLQuery<Q extends AbstractSQLQuery<Q>>
extends ProjectableQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQLQuery.class);
    @Nullable
    private final Connection conn;
    @Nullable
    private List<Object> constants;
    @Nullable
    private List<Path<?>> constantPaths;
    @Nullable
    protected SubQueryExpression<?>[] union;
    private final Configuration configuration;
    protected final SQLQueryMixin<Q> queryMixin;
    protected boolean unionAll;

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration) {
        this(conn, configuration, (QueryMetadata)new DefaultQueryMetadata().noValidate());
    }

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(new SQLQueryMixin(metadata));
        this.queryMixin = (SQLQueryMixin)((ProjectableQuery)this).queryMixin;
        this.queryMixin.setSelf((Object)this);
        this.conn = conn;
        this.configuration = configuration;
    }

    public Q addJoinFlag(String flag) {
        return this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    public Q addJoinFlag(String flag, JoinFlag.Position position) {
        List joins = this.queryMixin.getMetadata().getJoins();
        ((JoinExpression)joins.get(joins.size() - 1)).addFlag(new JoinFlag(flag, position));
        return (Q)((Object)this);
    }

    public Q addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        SimpleExpression flag = SimpleTemplate.create((Class)expr.getType(), (String)(prefix + "{0}"), (Expression[])new Expression[]{expr});
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, (Expression)flag)))));
    }

    public Q addFlag(QueryFlag.Position position, String flag) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    public Q addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    protected String buildQueryString(boolean forCountRow) {
        SQLSerializer serializer = this.createSerializer();
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstants();
        this.constantPaths = serializer.getConstantPaths();
        return serializer.toString();
    }

    public long count() {
        try {
            return this.unsafeCount();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean exists() {
        return ((AbstractSQLQuery)this.limit(1L)).uniqueResult((Expression)NumberTemplate.ONE) != null;
    }

    public Q forUpdate() {
        return this.addFlag(QueryFlag.Position.END, this.configuration.getTemplates().getForUpdate());
    }

    protected SQLSerializer createSerializer() {
        return new SQLSerializer(this.configuration.getTemplates());
    }

    public Q from(Expression<?> ... args) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(args))));
    }

    public Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(new Expression[]{ExpressionUtils.as(subQuery, alias)}))));
    }

    public Q fullJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(target))));
    }

    public <E> Q fullJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public Q fullJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <E> Q fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(entity))).on(key.on(entity));
    }

    public Q innerJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(target))));
    }

    public <E> Q innerJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public Q innerJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <E> Q innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public Q join(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(target))));
    }

    public <E> Q join(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(target, alias))));
    }

    public Q join(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(target, alias))));
    }

    public <E> Q join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.join(entity))).on(key.on(entity));
    }

    public Q leftJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(target))));
    }

    public <E> Q leftJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public Q leftJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public <E> Q leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(entity))).on(key.on(entity));
    }

    public Q rightJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(target))));
    }

    public <E> Q rightJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(target, alias))));
    }

    public Q rightJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(target, alias))));
    }

    public <E> Q rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(entity))).on(key.on(entity));
    }

    @Nullable
    private <T> T get(ResultSet rs, Expression<?> expr, int i, Class<T> type) throws SQLException {
        return this.configuration.get(rs, expr instanceof Path ? (Path)expr : null, i, type);
    }

    private int set(PreparedStatement stmt, Path<?> path, int i, Object value) throws SQLException {
        return this.configuration.set(stmt, path, i, value);
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    public ResultSet getResults(Expression<?> ... exprs) {
        this.queryMixin.addToProjection(exprs);
        String queryString = this.buildQueryString(false);
        logger.debug("query : {}", (Object)queryString);
        try {
            final PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.constantPaths, this.getMetadata().getParams());
            ResultSet rs = stmt.executeQuery();
            ResultSetAdapter resultSetAdapter = new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
            return resultSetAdapter;
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = sq;
        return new UnionImpl(this, this.union[0].getMetadata().getProjection());
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        this.queryMixin.addToProjection(args);
        return this.iterateMultiple(this.queryMixin.getMetadata());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> expr) {
        expr = this.queryMixin.convert(expr);
        this.queryMixin.addToProjection(new Expression[]{expr});
        return this.iterateSingle(this.queryMixin.getMetadata(), expr);
    }

    private CloseableIterator<Object[]> iterateMultiple(QueryMetadata metadata) {
        String queryString = this.buildQueryString(false);
        logger.debug("query : {}", (Object)queryString);
        try {
            PreparedStatement stmt = ((Connection)Assert.notNull((Object)this.conn, (String)"connection")).prepareStatement(queryString);
            final List projection = metadata.getProjection();
            this.setParameters(stmt, this.constants, this.constantPaths, metadata.getParams());
            ResultSet rs = stmt.executeQuery();
            SQLResultIterator<Object[]> sQLResultIterator = new SQLResultIterator<Object[]>((Statement)stmt, rs){

                @Override
                protected Object[] produceNext(ResultSet rs) {
                    try {
                        ArrayList<Object> objects = new ArrayList<Object>(projection.size());
                        int index = 0;
                        for (int i = 0; i < projection.size(); ++i) {
                            Expression expr = (Expression)projection.get(i);
                            if (expr instanceof FactoryExpression) {
                                objects.add(AbstractSQLQuery.this.newInstance((FactoryExpression)expr, rs, index));
                                index += ((FactoryExpression)expr).getArgs().size();
                                continue;
                            }
                            if (expr.getType().isArray()) {
                                for (int j = index; j < rs.getMetaData().getColumnCount(); ++j) {
                                    objects.add(AbstractSQLQuery.this.get(rs, expr, index++ + 1, Object.class));
                                }
                                i = objects.size();
                                continue;
                            }
                            objects.add(AbstractSQLQuery.this.get(rs, expr, index++ + 1, expr.getType()));
                        }
                        return objects.toArray();
                    }
                    catch (InstantiationException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (SQLException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <RT> CloseableIterator<RT> iterateSingle(QueryMetadata metadata, final @Nullable Expression<RT> expr) {
        String queryString = this.buildQueryString(false);
        logger.debug("query : {}", (Object)queryString);
        try {
            PreparedStatement stmt = ((Connection)Assert.notNull((Object)this.conn, (String)"connection")).prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.constantPaths, metadata.getParams());
            ResultSet rs = stmt.executeQuery();
            SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(stmt, rs){

                @Override
                public RT produceNext(ResultSet rs) {
                    try {
                        if (expr == null) {
                            return rs.getObject(1);
                        }
                        if (expr instanceof FactoryExpression) {
                            return AbstractSQLQuery.this.newInstance((FactoryExpression)expr, rs, 0);
                        }
                        if (expr.getType().isArray()) {
                            Object[] rv = new Object[rs.getMetaData().getColumnCount()];
                            for (int i = 0; i < rv.length; ++i) {
                                rv[i] = rs.getObject(i + 1);
                            }
                            return rv;
                        }
                        return AbstractSQLQuery.this.get(rs, expr, 1, expr.getType());
                    }
                    catch (IllegalAccessException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (InstantiationException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (SQLException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + queryString, (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    public List<Object[]> list(Expression<?>[] args) {
        return IteratorAdapter.asList(this.iterate(args));
    }

    public <RT> List<RT> list(Expression<RT> expr) {
        return IteratorAdapter.asList(this.iterate(expr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        this.queryMixin.addToProjection(new Expression[]{expr});
        long total = this.count();
        try {
            if (total > 0L) {
                this.queryMixin.getMetadata().clearProjection();
                QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
                SearchResults searchResults = new SearchResults(this.list(expr), modifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.reset();
        }
    }

    private <RT> RT newInstance(FactoryExpression<RT> c, ResultSet rs, int offset) throws InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        Object[] args = new Object[c.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.get(rs, (Expression)c.getArgs().get(i), offset + i + 1, ((Expression)c.getArgs().get(i)).getType());
        }
        return (RT)c.newInstance(args);
    }

    public Q on(Predicate ... conditions) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.on(conditions))));
    }

    private void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected void setParameters(PreparedStatement stmt, List<?> objects, List<Path<?>> constantPaths, Map<ParamExpression<?>, ?> params) {
        if (objects.size() != constantPaths.size()) {
            throw new IllegalArgumentException("Expected " + objects.size() + " paths, but got " + constantPaths.size());
        }
        int counter = 1;
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            try {
                if (ParamExpression.class.isInstance(o)) {
                    if (!params.containsKey(o)) {
                        throw new ParamNotSetException((ParamExpression)o);
                    }
                    o = params.get(o);
                }
                counter += this.set(stmt, constantPaths.get(i), counter, o);
                continue;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public String toString() {
        return this.buildQueryString(false).trim();
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from(UnionUtils.combineUnion(sq, alias, this.configuration.getTemplates(), false));
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from(UnionUtils.combineUnion(sq, alias, this.configuration.getTemplates(), false));
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from(UnionUtils.combineUnion(sq, alias, this.configuration.getTemplates(), true));
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from(UnionUtils.combineUnion(sq, alias, this.configuration.getTemplates(), true));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        if (this.getMetadata().getModifiers().getLimit() == null && !expr.toString().contains("count(")) {
            this.limit(2L);
        }
        CloseableIterator<RT> iterator = this.iterate(expr);
        return (RT)this.uniqueResult(iterator);
    }

    public Object[] uniqueResult(Expression<?>[] expr) {
        if (this.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        CloseableIterator<Object[]> iterator = this.iterate(expr);
        return (Object[])this.uniqueResult(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unsafeCount() throws SQLException {
        String queryString = this.buildQueryString(true);
        logger.debug("query : {}", (Object)queryString);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((Connection)Assert.notNull((Object)this.conn, (String)"connection")).prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.constantPaths, this.getMetadata().getParams());
            rs = stmt.executeQuery();
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

