/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.commons.lang.Pair;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.QueryException;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.path.NullExpr;
import com.mysema.query.types.path.PEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public class SQLUpdateClause
extends AbstractSQLClause
implements UpdateClause<SQLUpdateClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLInsertClause.class);
    private final Connection connection;
    private final PEntity<?> entity;
    private final List<Pair<Path<?>, ?>> updates = new ArrayList();
    private final BooleanBuilder where = new BooleanBuilder();

    public SQLUpdateClause(Connection connection, SQLTemplates templates, PEntity<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLUpdateClause(Connection connection, Configuration configuration, PEntity<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
    }

    protected void close(PreparedStatement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public long execute() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForUpdate(this.entity, this.updates, this.where.getValue());
        String queryString = serializer.toString();
        logger.debug(queryString);
        PreparedStatement stmt = null;
        try {
            stmt = this.connection.prepareStatement(queryString);
            this.setParameters(stmt, serializer.getConstants(), Collections.emptyMap());
            long l = stmt.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public <T> SQLUpdateClause set(Path<T> path, T value) {
        if (value != null) {
            this.updates.add(Pair.of(path, value));
        } else {
            this.updates.add(Pair.of(path, (Object)new NullExpr(path.getType())));
        }
        return this;
    }

    public SQLUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) != null) {
                this.updates.add(Pair.of(paths.get(i), values.get(i)));
                continue;
            }
            this.updates.add(Pair.of(paths.get(i), (Object)new NullExpr(paths.get(i).getType())));
        }
        return this;
    }

    public SQLUpdateClause where(EBoolean ... o) {
        for (EBoolean e : o) {
            this.where.and(e);
        }
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForUpdate(this.entity, this.updates, this.where.getValue());
        return serializer.toString();
    }
}

